/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.SearchDialog;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.internetsearch.Search;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class SearchArtistAtAction
extends AbstractAction {
    private static final long serialVersionUID = -8934175706272236046L;

    SearchArtistAtAction() {
        super(StringUtils.getString(I18nUtils.getString("SEARCH_ARTIST_AT"), "..."), Images.getImage("searchWith.png"));
        this.putValue("ShortDescription", StringUtils.getString(I18nUtils.getString("SEARCH_ARTIST_AT"), "..."));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getCurrentView().getTree().getSelectionPath();
        if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof Artist) {
            Artist artist = (Artist)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            SearchDialog searchDialog = GuiHandler.getInstance().getSearchDialog();
            Search search = ControllerProxy.getInstance().getNavigationController().openSearchDialog(searchDialog, true);
            if (searchDialog.isSetAsDefault() && search != null) {
                ApplicationState.getInstance().setDefaultSearch(((Object)search).toString());
            }
            if (search != null) {
                DesktopUtils.openSearch(search, artist.getName());
            }
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Artist && !((Artist)defaultMutableTreeNode.getUserObject()).isUnknownArtist()) continue;
            return false;
        }
        return true;
    }
}

