/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class SynchronizeDeviceWithPlayListAction
extends AbstractAction {
    private static final long serialVersionUID = -1885495996370465881L;
    private Logger logger;

    public SynchronizeDeviceWithPlayListAction() {
        super(I18nUtils.getString("SYNCHRONIZE_DEVICE_WITH_PLAYLIST"));
        this.putValue("ShortDescription", I18nUtils.getString("SYNCHRONIZE_DEVICE_WITH_PLAYLIST"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SynchronizeDeviceWithPlayListSwingWorker synchronizeDeviceWithPlayListSwingWorker = new SynchronizeDeviceWithPlayListSwingWorker();
        synchronizeDeviceWithPlayListSwingWorker.execute();
        GuiHandler.getInstance().showIndeterminateProgressDialog(I18nUtils.getString("PLEASE_WAIT"));
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class SynchronizeDeviceWithPlayListSwingWorker
    extends SwingWorker<Map<String, List<AudioFile>>, Void> {
        private int filesRemoved = 0;
        private ProcessListener listener = new ProcessListener(){

            @Override
            public void processCanceled() {
            }

            @Override
            public void processFinished(boolean bl) {
                SynchronizeDeviceWithPlayListSwingWorker.this.showMessage(true);
            }
        };

        private SynchronizeDeviceWithPlayListSwingWorker() {
        }

        protected void showMessage(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiHandler.getInstance().showMessage(StringUtils.getString(I18nUtils.getString("SYNCHRONIZATION_FINISHED"), " ", I18nUtils.getString("ADDED"), ": ", bl ? DeviceHandler.getInstance().getFilesCopiedToDevice() : 0, " ", I18nUtils.getString("REMOVED"), ": ", SynchronizeDeviceWithPlayListSwingWorker.this.filesRemoved));
                }
            });
        }

        @Override
        protected Map<String, List<AudioFile>> doInBackground() {
            List<AudioFile> list = ApplicationState.getInstance().isAllowRepeatedSongsInDevice() ? AudioFile.filterRepeatedSongsAndAlbums(AudioFile.getAudioFiles(PlayListHandler.getInstance().getCurrentPlayList(true).getObjectsOfType(AudioFile.class))) : AudioFile.filterRepeatedSongs(AudioFile.getAudioFiles(PlayListHandler.getInstance().getCurrentPlayList(true).getObjectsOfType(AudioFile.class)));
            List<AudioFile> list2 = DeviceHandler.getInstance().getElementsNotPresentInDevice(list);
            List<AudioFile> list3 = DeviceHandler.getInstance().getElementsNotPresentInList(list);
            HashMap<String, List<AudioFile>> hashMap = new HashMap<String, List<AudioFile>>();
            hashMap.put("ADD", list2);
            hashMap.put("REMOVE", list3);
            this.filesRemoved = list3.size();
            return hashMap;
        }

        @Override
        protected void done() {
            try {
                Map map = (Map)this.get();
                GuiHandler.getInstance().hideIndeterminateProgressDialog();
                final List list = (List)map.get("REMOVE");
                RepositoryHandler.getInstance().remove(list);
                SynchronizeDeviceWithPlayListAction.this.setEnabled(false);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        for (AudioFile audioFile : list) {
                            File file = audioFile.getFile();
                            if (file == null) continue;
                            file.delete();
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        SynchronizeDeviceWithPlayListAction.this.setEnabled(true);
                    }
                }.execute();
                if (!((List)map.get("ADD")).isEmpty()) {
                    DeviceHandler.getInstance().copyFilesToDevice((Collection)map.get("ADD"), this.listener);
                } else {
                    this.showMessage(false);
                }
            }
            catch (Exception exception) {
                SynchronizeDeviceWithPlayListAction.this.getLogger().error("ACTION      ", exception);
            }
        }
    }
}

