/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.customsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.gui.views.dialogs.CustomSearchDialog;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.controllers.customsearch.ComplexTreeSelectionListener;
import net.sourceforge.atunes.kernel.controllers.customsearch.CustomSearchListener;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.search.EmptyRule;
import net.sourceforge.atunes.kernel.modules.search.SearchHandler;
import net.sourceforge.atunes.kernel.modules.search.SearchIndexNotAvailableException;
import net.sourceforge.atunes.kernel.modules.search.SearchQuerySyntaxException;
import net.sourceforge.atunes.kernel.modules.search.SearchableObject;
import net.sourceforge.atunes.kernel.modules.search.SimpleRule;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public final class CustomSearchController
extends AbstractSimpleController<CustomSearchDialog> {
    private List<SearchableObject> searchableObjects;
    private Map<String, String> translatedAttributes = new HashMap<String, String>();

    public CustomSearchController(CustomSearchDialog customSearchDialog) {
        super(customSearchDialog);
        this.addBindings();
    }

    public void showSearchDialog() {
        ((DefaultTreeModel)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel()).setRoot(null);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesComboBox().setSelectedIndex(0);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesTextField().setText("");
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchCheckBox().setSelected(ApplicationState.getInstance().isEnableAdvancedSearch());
        this.enableAdvancedSearch(ApplicationState.getInstance().isEnableAdvancedSearch());
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchTextField().setText("");
        ((CustomSearchDialog)this.getComponentControlled()).setVisible(true);
    }

    public void setListOfSearchableObjects(List<SearchableObject> list) {
        if (!list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SearchableObject searchableObject : list) {
                arrayList.add(searchableObject.getSearchableObjectName());
            }
            ((CustomSearchDialog)this.getComponentControlled()).getSearchAtComboBox().setModel(new ListComboBoxModel(arrayList));
            this.searchableObjects = list;
            ((CustomSearchDialog)this.getComponentControlled()).getSearchAtComboBox().setSelectedIndex(0);
        }
    }

    public void setListOfOperators(List<String> list) {
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesComboBox().setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public void updateAttributesList() {
        if (this.searchableObjects != null) {
            SearchableObject searchableObject = this.searchableObjects.get(((CustomSearchDialog)this.getComponentControlled()).getSearchAtComboBox().getSelectedIndex());
            List<String> list = searchableObject.getSearchableAttributes();
            list.add(0, "any");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                String string2 = I18nUtils.getString(string.toUpperCase());
                arrayList.add(string2);
                this.translatedAttributes.put(string2, string);
            }
            ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesList().setListData(arrayList.toArray());
        }
    }

    public void createSimpleRule() {
        String string = (String)((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesList().getSelectedValue();
        String string2 = (String)((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesComboBox().getSelectedItem();
        String string3 = ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesTextField().getText();
        SimpleRule simpleRule = new SimpleRule(string, string2, string3);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(simpleRule);
        if (defaultMutableTreeNode == null) {
            defaultTreeModel.setRoot(defaultMutableTreeNode2);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getSelectionPath().getLastPathComponent();
            if (defaultMutableTreeNode3.getUserObject() instanceof EmptyRule) {
                defaultMutableTreeNode3.setUserObject(simpleRule);
            } else {
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            }
        }
        defaultTreeModel.reload();
        this.updateAdvancedSearchTextField();
        GuiUtils.expandTree(((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree());
    }

    public void addAndOperator() {
        this.addLogicalOperator(SearchHandler.LogicalOperator.AND);
    }

    public void addOrOperator() {
        this.addLogicalOperator(SearchHandler.LogicalOperator.OR);
    }

    public void addNotOperator() {
        this.addLogicalOperator(SearchHandler.LogicalOperator.NOT);
    }

    private void addLogicalOperator(SearchHandler.LogicalOperator logicalOperator) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)logicalOperator);
        if (defaultMutableTreeNode2 == null) {
            defaultTreeModel.setRoot(defaultMutableTreeNode3);
        } else {
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode);
        if (!logicalOperator.equals((Object)SearchHandler.LogicalOperator.NOT)) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new EmptyRule());
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        defaultTreeModel.reload();
        this.updateAdvancedSearchTextField();
        GuiUtils.expandTree(((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree());
    }

    private void updateAdvancedSearchTextField() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel().getRoot();
        String string = "";
        if (defaultMutableTreeNode != null) {
            string = this.createQuery(defaultMutableTreeNode);
        }
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchTextField().setText(string);
    }

    private String createQuery(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.isLeaf()) {
            return defaultMutableTreeNode.getUserObject().toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (defaultMutableTreeNode.getUserObject().equals((Object)SearchHandler.LogicalOperator.NOT)) {
            stringBuilder.append(defaultMutableTreeNode.getUserObject());
            stringBuilder.append(" ");
            stringBuilder.append(this.createQuery((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)));
        } else {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount() - 1; ++i) {
                stringBuilder.append(this.createQuery((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)));
                stringBuilder.append(" ");
                stringBuilder.append(defaultMutableTreeNode.toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.createQuery((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1)));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void removeRuleNode() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode.isRoot()) {
            defaultTreeModel.setRoot(null);
            ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesAddButton().setEnabled(true);
        } else if (defaultMutableTreeNode2.getChildCount() > 2) {
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode.setUserObject(new EmptyRule());
            if (!(defaultMutableTreeNode.getUserObject() instanceof SimpleRule)) {
                defaultMutableTreeNode.removeAllChildren();
            }
        }
        defaultTreeModel.reload();
        this.updateAdvancedSearchTextField();
        GuiUtils.expandTree(((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree());
    }

    private String translateQuery(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.translatedAttributes.keySet());
        Collections.sort(arrayList, new TranslatedAttributesList());
        String string2 = string;
        for (String string3 : arrayList) {
            string2 = string2.replaceAll(string3, this.translatedAttributes.get(string3));
        }
        return string2;
    }

    public void search() {
        block6: {
            if (this.searchableObjects != null) {
                SearchableObject searchableObject = this.searchableObjects.get(((CustomSearchDialog)this.getComponentControlled()).getSearchAtComboBox().getSelectedIndex());
                String string = ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchTextField().getText();
                string = this.translateQuery(string);
                try {
                    List<AudioObject> list = SearchHandler.getInstance().search(searchableObject, string);
                    if (list.isEmpty()) {
                        GuiHandler.getInstance().showMessage(I18nUtils.getString("NO_MATCHES_FOUND"));
                        break block6;
                    }
                    this.showSearchResults(searchableObject, list);
                }
                catch (SearchIndexNotAvailableException searchIndexNotAvailableException) {
                    GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("INVALID_SEARCH_RULE"));
                }
                catch (SearchQuerySyntaxException searchQuerySyntaxException) {
                    GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("INVALID_SEARCH_RULE"));
                }
            } else {
                GuiHandler.getInstance().showMessage(I18nUtils.getString("NO_MATCHES_FOUND"));
            }
        }
    }

    private void showSearchResults(SearchableObject searchableObject, List<AudioObject> list) {
        ((CustomSearchDialog)this.getComponentControlled()).setVisible(false);
        ControllerProxy.getInstance().getSearchResultsController().showSearchResults(searchableObject, list);
    }

    public void enableAdvancedSearch(boolean bl) {
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesAddButton().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesComboBox().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesList().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesTextField().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesAndButton().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesOrButton().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesNotButton().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesRemoveButton().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().setEnabled(!bl);
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchTextField().setEnabled(bl);
    }

    @Override
    protected void addBindings() {
        CustomSearchListener customSearchListener = new CustomSearchListener((CustomSearchDialog)this.getComponentControlled());
        ((CustomSearchDialog)this.getComponentControlled()).getSearchAtComboBox().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getSimpleRulesAddButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().setModel(new DefaultTreeModel(null));
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesAndButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesOrButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesNotButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesRemoveButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchCheckBox().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getSearchButton().addActionListener(customSearchListener);
        ComplexTreeSelectionListener complexTreeSelectionListener = new ComplexTreeSelectionListener((CustomSearchDialog)this.getComponentControlled(), ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree());
        ((CustomSearchDialog)this.getComponentControlled()).getComplexRulesTree().addTreeSelectionListener(complexTreeSelectionListener);
        ((CustomSearchDialog)this.getComponentControlled()).getCancelButton().addActionListener(customSearchListener);
        ((CustomSearchDialog)this.getComponentControlled()).getAdvancedSearchTextField().addActionListener(customSearchListener);
    }

    @Override
    protected void addStateBindings() {
    }

    @Override
    protected void notifyReload() {
    }

    private static class TranslatedAttributesList
    implements Comparator<String> {
        private TranslatedAttributesList() {
        }

        @Override
        public int compare(String string, String string2) {
            return -Integer.valueOf(string.length()).compareTo(string2.length());
        }
    }
}

