/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.playListTab;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.gui.views.controls.ColumnSetPopupMenu;
import net.sourceforge.atunes.gui.views.panels.PlayListTabPanel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.CloseOtherPlaylistsAction;
import net.sourceforge.atunes.kernel.actions.ClosePlaylistAction;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.utils.StringUtils;

final class PlayListTabListener
extends MouseAdapter
implements ActionListener,
ChangeListener {
    private PlayListTabPanel panel;

    public PlayListTabListener(PlayListTabPanel playListTabPanel) {
        this.panel = playListTabPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.getPlayListsPopUpButton()) {
            this.panel.getPlayListsPopUpButton().removeAllItems();
            this.panel.addFixedMenuItems();
            List<String> list = ControllerProxy.getInstance().getPlayListTabController().getNamesOfPlayLists();
            for (int i = 0; i < list.size(); ++i) {
                int n = i;
                JMenuItem jMenuItem = PlayListHandler.getInstance().isVisiblePlayList(n) ? new JMenuItem(StringUtils.getString("<html><b>", list.get(i), "</b></html>")) : new JMenuItem(list.get(i));
                jMenuItem.addActionListener(new SwitchPlayListListener(n));
                this.panel.getPlayListsPopUpButton().add(jMenuItem);
            }
        } else if (actionEvent.getSource() == this.panel.getArrangeColumnsMenuItem()) {
            ColumnSetPopupMenu.selectColumns((AbstractCommonColumnModel)ControllerProxy.getInstance().getPlayListController().getMainPlayListTable().getColumnModel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            boolean bl = PlayListHandler.getInstance().getPlayListCount() > 1;
            Actions.getAction(ClosePlaylistAction.class).setEnabled(bl);
            Actions.getAction(CloseOtherPlaylistsAction.class).setEnabled(bl);
            this.panel.getPopupMenu().show(this.panel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        PlayListHandler.getInstance().switchToPlaylist(this.panel.getPlayListTabbedPane().getSelectedIndex());
    }

    private static class SwitchPlayListListener
    implements ActionListener {
        private int index;

        public SwitchPlayListListener(int n) {
            this.index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ControllerProxy.getInstance().getPlayListTabController().forceSwitchTo(this.index);
        }
    }
}

