/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper;

import java.awt.Cursor;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.views.dialogs.RipCdDialog;
import net.sourceforge.atunes.gui.views.dialogs.RipperProgressDialog;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.RipCDAction;
import net.sourceforge.atunes.kernel.modules.cdripper.CdRipper;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.AbstractCdToWavConverter;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.NoCdListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.TrackInfo;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class RipperHandler
extends AbstractHandler {
    private static RipperHandler instance = new RipperHandler();
    private CdRipper ripper;
    private volatile boolean interrupted;
    private boolean folderCreated;
    private String albumCoverURL;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Map<String, Encoder> availableEncoders;
    private static List<String> allEncoders = new ArrayList<String>();

    private RipperHandler() {
    }

    public static RipperHandler getInstance() {
        return instance;
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    public void applicationStarted() {
    }

    @Override
    protected void initHandler() {
    }

    private void addFilesToRepositoryAndRefresh(List<File> list, File file) {
        if (RepositoryHandler.getInstance().isRepository(file)) {
            RepositoryHandler.getInstance().addFilesAndRefresh(list);
        }
    }

    public void cancelProcess() {
        this.interrupted = true;
        this.ripper.stop();
        RipperHandler.getLogger().info("RIPPER      ", "Process cancelled");
    }

    public void fillSongTitles(String string, String string2) {
        GuiHandler.getInstance().getRipCdDialog().setCursor(Cursor.getPredefinedCursor(3));
        GuiHandler.getInstance().getRipCdDialog().getTitlesButton().setEnabled(false);
        new FillSongTitlesSwingWorker(string, string2).execute();
    }

    public String getEncoder() {
        String string = ApplicationState.getInstance().getEncoder();
        if (this.getAvailableEncoders().containsKey(string)) {
            return string;
        }
        Encoder encoder = null;
        for (Encoder encoder2 : this.getAvailableEncoders().values()) {
            if (encoder == null) {
                encoder = encoder2;
                continue;
            }
            int n = allEncoders.indexOf(encoder2.getClass().getName());
            if (n == -1 || n >= allEncoders.indexOf(encoder.getClass().getName())) continue;
            encoder = encoder2;
        }
        if (encoder != null) {
            return encoder.getFormatName();
        }
        return null;
    }

    public String[] getEncoderQualities(String string) {
        if (this.getAvailableEncoders().containsKey(string)) {
            return this.getAvailableEncoders().get(string).getAvailableQualities();
        }
        return new String[0];
    }

    public String getEncoderDefaultQuality(String string) {
        if (this.getAvailableEncoders().containsKey(string)) {
            return this.getAvailableEncoders().get(string).getDefaultQuality();
        }
        return "";
    }

    public String getEncoderQuality() {
        return ApplicationState.getInstance().getEncoderQuality();
    }

    public String getFileNamePattern() {
        return ApplicationState.getInstance().getCdRipperFileNamePattern();
    }

    public Map<String, Encoder> getAvailableEncoders() {
        if (this.availableEncoders == null) {
            this.availableEncoders = new HashMap<String, Encoder>();
            for (String string : allEncoders) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (Encoder.class.isAssignableFrom(clazz)) {
                        Method method = clazz.getMethod("testTool", new Class[0]);
                        Boolean bl = (Boolean)method.invoke(null, new Object[0]);
                        if (!bl.booleanValue()) continue;
                        Encoder encoder = (Encoder)clazz.newInstance();
                        this.availableEncoders.put(encoder.getFormatName(), encoder);
                        continue;
                    }
                    RipperHandler.getLogger().error("RIPPER      ", clazz + " is not a subtype of " + Encoder.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    RipperHandler.getLogger().error("RIPPER      ", classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    RipperHandler.getLogger().error("RIPPER      ", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    RipperHandler.getLogger().error("RIPPER      ", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    RipperHandler.getLogger().error("RIPPER      ", invocationTargetException);
                }
                catch (InstantiationException instantiationException) {
                    RipperHandler.getLogger().error("RIPPER      ", instantiationException);
                }
            }
            RipperHandler.getLogger().info("RIPPER      ", StringUtils.getString("Available encoders: ", this.availableEncoders.keySet()));
        }
        return this.availableEncoders;
    }

    public boolean getCdErrorCorrection() {
        return ApplicationState.getInstance().isUseCdErrorCorrection();
    }

    void importSongs(String string, String string2, String string3, int n, String string4, final List<Integer> list, final List<String> list2, final List<String> list3, final List<String> list4, String string5, String string6, final boolean bl) {
        Object object;
        Actions.getAction(RipCDAction.class).setEnabled(false);
        final File file = new File(string);
        if (!file.exists()) {
            if (file.mkdirs()) {
                this.folderCreated = true;
            } else {
                RipperHandler.getLogger().error("RIPPER      ", "Folder could not be created");
                return;
            }
        }
        Encoder encoder = this.getAvailableEncoders().get(string5);
        encoder.setQuality(string6);
        this.ripper.setEncoder(encoder);
        this.ripper.setArtist(string2);
        this.ripper.setAlbum(string3);
        this.ripper.setYear(n);
        this.ripper.setGenre(string4);
        this.ripper.setFileNamePattern(this.getFileNamePattern());
        RipperProgressDialog ripperProgressDialog = GuiHandler.getInstance().getRipperProgressDialog();
        if (this.albumCoverURL != null) {
            object = LastFmService.getInstance().getImage(this.albumCoverURL);
            ripperProgressDialog.setCover((Image)object);
            this.savePicture((Image)object, file, string2, string3);
        }
        ripperProgressDialog.setArtistAndAlbum(string2, string3);
        ripperProgressDialog.setTotalProgressBarLimits(0, list.size());
        ripperProgressDialog.setTotalProgressValue(0);
        object = new ArrayList();
        this.ripper.setDecoderListener(new DecoderProgressListener(ripperProgressDialog));
        this.ripper.setEncoderListener(new EncoderProgressListener(ripperProgressDialog));
        this.ripper.setTotalProgressListener(new TotalProgressListener(ripperProgressDialog, (List)object));
        new SwingWorker<Boolean, Void>((List)object){
            final /* synthetic */ List val$filesImported;
            {
                this.val$filesImported = list5;
            }

            @Override
            protected Boolean doInBackground() throws Exception {
                return RipperHandler.this.ripper.ripTracks(list, list2, file, list3, list4, bl);
            }

            @Override
            protected void done() {
                RipperHandler.this.notifyFinishImport(this.val$filesImported, file);
                Actions.getAction(RipCDAction.class).setEnabled(true);
            }
        }.execute();
        ripperProgressDialog.setVisible(true);
    }

    public void notifyFinishImport(final List<File> list, final File file) {
        GuiHandler.getInstance().getRipperProgressDialog().setVisible(false);
        if (this.interrupted) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (File file2 : list) {
                        file2.delete();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        RipperHandler.getLogger().internalError(interruptedException);
                    }
                    if (RipperHandler.this.folderCreated) {
                        file.delete();
                    }
                }
            };
            this.executorService.submit(runnable);
        } else {
            this.addFilesToRepositoryAndRefresh(list, file);
        }
    }

    private void savePicture(Image image, File file, String string, String string2) {
        String string3 = StringUtils.getString(file.getAbsolutePath(), SystemProperties.FILE_SEPARATOR, string, "_", string2, "_Cover.png");
        try {
            ImageUtils.writeImageToFile(image, string3);
        }
        catch (IOException iOException) {
            RipperHandler.getLogger().internalError(iOException);
        }
    }

    void setEncoder(String string) {
        ApplicationState.getInstance().setEncoder(string);
    }

    void setEncoderQuality(String string) {
        ApplicationState.getInstance().setEncoderQuality(string);
    }

    void setFileNamePattern(String string) {
        ApplicationState.getInstance().setCdRipperFileNamePattern(string);
    }

    void setUseCdErrorCorrection(boolean bl) {
        ApplicationState.getInstance().setUseCdErrorCorrection(bl);
    }

    public void startCdRipper() {
        this.interrupted = false;
        RipCdDialog ripCdDialog = GuiHandler.getInstance().getRipCdDialog();
        GuiHandler.getInstance().showIndeterminateProgressDialog(I18nUtils.getString("RIP_CD"));
        GetCdInfoAndStartRippingSwingWorker getCdInfoAndStartRippingSwingWorker = new GetCdInfoAndStartRippingSwingWorker(ripCdDialog);
        getCdInfoAndStartRippingSwingWorker.execute();
    }

    boolean testTools() {
        if (!AbstractCdToWavConverter.testTool()) {
            RipperHandler.getLogger().error("RIPPER      ", "Error testing \"cdda2wav\" or \"cdparanoia\". Check program is installed");
            SwingUtilities.invokeLater(new ShowErrorDialogRunnable());
            return false;
        }
        return true;
    }

    static {
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.OggEncoder");
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.LameEncoder");
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.Mp4Encoder");
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.NeroAacEncoder");
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.FlacEncoder");
        allEncoders.add("net.sourceforge.atunes.kernel.modules.cdripper.encoders.WavEncoder");
    }

    private static final class DecoderProgressListener
    implements ProgressListener {
        private final RipperProgressDialog dialog;

        private DecoderProgressListener(RipperProgressDialog ripperProgressDialog) {
            this.dialog = ripperProgressDialog;
        }

        @Override
        public void notifyFileFinished(File file) {
        }

        @Override
        public void notifyProgress(int n) {
            this.dialog.setDecodeProgressValue(n);
            if (n > 0) {
                this.dialog.setDecodeProgressValue(StringUtils.getString(n, "%"));
            } else {
                this.dialog.setDecodeProgressValue("");
            }
        }
    }

    private static final class EncoderProgressListener
    implements ProgressListener {
        private final RipperProgressDialog dialog;

        private EncoderProgressListener(RipperProgressDialog ripperProgressDialog) {
            this.dialog = ripperProgressDialog;
        }

        @Override
        public void notifyFileFinished(File file) {
        }

        @Override
        public void notifyProgress(int n) {
            this.dialog.setEncodeProgressValue(n);
            if (n >= 0) {
                this.dialog.setEncodeProgressValue(StringUtils.getString(n, "%"));
            }
        }
    }

    private static final class TotalProgressListener
    implements ProgressListener {
        private final RipperProgressDialog dialog;
        private final List<File> filesImported;

        private TotalProgressListener(RipperProgressDialog ripperProgressDialog, List<File> list) {
            this.dialog = ripperProgressDialog;
            this.filesImported = list;
        }

        @Override
        public void notifyFileFinished(File file) {
            this.filesImported.add(file);
        }

        @Override
        public void notifyProgress(int n) {
            this.dialog.setTotalProgressValue(n);
            this.dialog.setDecodeProgressValue(0);
            this.dialog.setDecodeProgressValue(StringUtils.getString(0, "%"));
            this.dialog.setEncodeProgressValue(0);
            this.dialog.setEncodeProgressValue(StringUtils.getString(0, "%"));
        }
    }

    private static class ShowErrorDialogRunnable
    implements Runnable {
        private ShowErrorDialogRunnable() {
        }

        @Override
        public void run() {
            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("CDDA2WAV_NOT_FOUND"));
        }
    }

    private final class GetCdInfoAndStartRippingSwingWorker
    extends SwingWorker<CDInfo, Void> {
        private final RipCdDialog dialog;

        private GetCdInfoAndStartRippingSwingWorker(RipCdDialog ripCdDialog) {
            this.dialog = ripCdDialog;
        }

        @Override
        protected CDInfo doInBackground() throws Exception {
            if (!RipperHandler.this.testTools()) {
                return null;
            }
            RipperHandler.this.ripper = new CdRipper();
            RipperHandler.this.ripper.setNoCdListener(new NoCdListener(){

                @Override
                public void noCd() {
                    RipperHandler.getLogger().error("RIPPER      ", "No cd inserted");
                    RipperHandler.this.interrupted = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiHandler.getInstance().hideIndeterminateProgressDialog();
                            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("NO_CD_INSERTED"));
                        }
                    });
                }
            });
            return RipperHandler.this.ripper.getCDInfo();
        }

        @Override
        protected void done() {
            GuiHandler.getInstance().hideIndeterminateProgressDialog();
            try {
                CDInfo cDInfo = (CDInfo)this.get();
                if (cDInfo != null) {
                    ControllerProxy.getInstance().getRipCdDialogController().showCdInfo(cDInfo, RepositoryHandler.getInstance().getPathForNewAudioFilesRipped());
                    if (!ControllerProxy.getInstance().getRipCdDialogController().isCancelled()) {
                        String string = ControllerProxy.getInstance().getRipCdDialogController().getArtist();
                        String string2 = ControllerProxy.getInstance().getRipCdDialogController().getAlbum();
                        int n = ControllerProxy.getInstance().getRipCdDialogController().getYear();
                        String string3 = ControllerProxy.getInstance().getRipCdDialogController().getGenre();
                        String string4 = ControllerProxy.getInstance().getRipCdDialogController().getFolder();
                        List<Integer> list = this.dialog.getTracksSelected();
                        List<String> list2 = this.dialog.getTrackNames();
                        List<String> list3 = this.dialog.getArtistNames();
                        List<String> list4 = this.dialog.getComposerNames();
                        RipperHandler.this.setUseCdErrorCorrection(this.dialog.getUseCdErrorCorrection().isSelected());
                        RipperHandler.this.setEncoder(this.dialog.getFormat().getSelectedItem().toString());
                        RipperHandler.this.setEncoderQuality(this.dialog.getQuality());
                        RipperHandler.this.setFileNamePattern(this.dialog.getFileNamePattern());
                        RipperHandler.this.importSongs(string4, string, string2, n, string3, list, list2, list3, list4, this.dialog.getFormat().getSelectedItem().toString(), this.dialog.getQuality(), this.dialog.getUseCdErrorCorrection().isSelected());
                    } else {
                        RipperHandler.this.setUseCdErrorCorrection(this.dialog.getUseCdErrorCorrection().isSelected());
                        RipperHandler.this.setEncoder(this.dialog.getFormat().getSelectedItem().toString());
                        RipperHandler.this.setEncoderQuality(this.dialog.getQuality());
                        RipperHandler.this.setFileNamePattern(this.dialog.getFileNamePattern());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                GuiHandler.getInstance().getRipCdDialog().setVisible(false);
                RipperHandler.getLogger().internalError(interruptedException);
            }
            catch (ExecutionException executionException) {
                GuiHandler.getInstance().getRipCdDialog().setVisible(false);
                RipperHandler.getLogger().internalError(executionException);
            }
        }
    }

    private final class FillSongTitlesSwingWorker
    extends SwingWorker<AlbumInfo, Void> {
        private final String artist;
        private final String album;

        private FillSongTitlesSwingWorker(String string, String string2) {
            this.artist = string;
            this.album = string2;
        }

        @Override
        protected AlbumInfo doInBackground() throws Exception {
            return LastFmService.getInstance().getAlbum(this.artist, this.album);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                if (this.get() != null) {
                    RipperHandler.this.albumCoverURL = ((AlbumInfo)this.get()).getCoverURL();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (TrackInfo trackInfo : ((AlbumInfo)this.get()).getTracks()) {
                        arrayList.add(trackInfo.getTitle());
                    }
                    GuiHandler.getInstance().getRipCdDialog().updateTrackNames(arrayList);
                }
            }
            catch (InterruptedException interruptedException) {
                RipperHandler.getLogger().internalError(interruptedException);
            }
            catch (ExecutionException executionException) {
                RipperHandler.getLogger().error("RIPPER      ", executionException);
            }
            finally {
                GuiHandler.getInstance().getRipCdDialog().setCursor(Cursor.getDefaultCursor());
                GuiHandler.getInstance().getRipCdDialog().getTitlesButton().setEnabled(true);
            }
        }
    }
}

