/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;

public class ScoreColumn
extends AbstractColumn {
    private static final long serialVersionUID = -2673502888298485650L;

    public ScoreColumn() {
        super("SCORE", Integer.class);
        this.setWidth(100);
        this.setVisible(true);
        this.setEditable(true);
    }

    @Override
    public TableCellEditor getCellEditor() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{0, 1, 2, 3, 4, 5});
        jComboBox.setRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getListCellRenderer(new AbstractListCellRendererCode(){

            @Override
            public Component getComponent(Component component, JList jList, Object object, int n, boolean bl, boolean bl2) {
                ScoreColumn.this.setLabel((JLabel)component, (Integer)object);
                return component;
            }
        }));
        return new DefaultCellEditor(jComboBox);
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new AbstractTableCellRendererCode(){

            @Override
            public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ScoreColumn.this.setLabel((JLabel)component, (Integer)object);
                return component;
            }
        });
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return -Integer.valueOf(audioObject.getStars()).compareTo(audioObject2.getStars());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        return audioObject.getStars();
    }

    @Override
    public void setValueFor(AudioObject audioObject, Object object) {
        audioObject.setStars((Integer)object);
    }

    private void setLabel(JLabel jLabel, int n) {
        jLabel.setText(null);
        switch (n) {
            case 0: {
                jLabel.setIcon(Images.getImage("empty.png"));
                break;
            }
            case 1: {
                jLabel.setIcon(Images.getImage("1_star.png"));
                break;
            }
            case 2: {
                jLabel.setIcon(Images.getImage("2_star.png"));
                break;
            }
            case 3: {
                jLabel.setIcon(Images.getImage("3_star.png"));
                break;
            }
            case 4: {
                jLabel.setIcon(Images.getImage("4_star.png"));
                break;
            }
            case 5: {
                jLabel.setIcon(Images.getImage("5_star.png"));
                break;
            }
            default: {
                jLabel.setIcon(Images.getImage("empty.png"));
            }
        }
    }
}

