/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationSwingWorker;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import org.commonjukebox.plugins.model.PluginApi;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.border.DropShadowBorder;

@PluginApi
public abstract class AbstractContextPanelContent {
    private static final long serialVersionUID = 7059398864514654378L;
    private ContextInformationDataSource dataSource;
    private ContextInformationSwingWorker worker;
    private JXTaskPane parentTaskPane;

    protected AbstractContextPanelContent(ContextInformationDataSource contextInformationDataSource) {
        this.dataSource = contextInformationDataSource;
    }

    protected final void updateContextPanelContent(AudioObject audioObject) {
        this.callDataSource(this.getDataSourceParameters(audioObject));
    }

    private void callDataSource(Map<String, ?> map) {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new ContextInformationSwingWorker(this, this.dataSource, map);
        this.worker.execute();
    }

    protected void clearContextPanelContent() {
        this.parentTaskPane.setCollapsed(true);
        this.parentTaskPane.setEnabled(false);
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    protected boolean isScrollNeeded() {
        return false;
    }

    protected abstract Map<String, ?> getDataSourceParameters(AudioObject var1);

    protected abstract void updateContentWithDataSourceResult(Map<String, ?> var1);

    protected abstract String getContentName();

    protected abstract Component getComponent();

    protected List<Component> getOptions() {
        return null;
    }

    protected static JPanel getPanelForTableRenderer(ImageIcon imageIcon, String string, Color color, int n, int n2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setOpaque(false);
        jLabel.setBorder((Border)(imageIcon != null ? new DropShadowBorder() : null));
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setOpaque(false);
        jLabel2.setVerticalAlignment(1);
        jPanel.setOpaque(false);
        if (color != null) {
            jLabel2.setBackground(color);
            jPanel.setBackground(color);
            jLabel.setBackground(color);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, (n + 20) / 2 - (imageIcon != null ? imageIcon.getIconWidth() : 0) / 2, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, (n + 20) / 2 - (imageIcon != null ? imageIcon.getIconWidth() : 0) / 2, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        GuiUtils.applyComponentOrientation(jPanel);
        return jPanel;
    }

    protected void setParentTaskPane(JXTaskPane jXTaskPane) {
        this.parentTaskPane = jXTaskPane;
    }

    protected JXTaskPane getParentTaskPane() {
        return this.parentTaskPane;
    }
}

