/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.album.AlbumContextPanel;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistContextPanel;
import net.sourceforge.atunes.kernel.modules.context.audioobject.AudioObjectContextPanel;
import net.sourceforge.atunes.kernel.modules.context.similar.SimilarArtistsContextPanel;
import net.sourceforge.atunes.kernel.modules.context.youtube.YoutubeContextPanel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListEventListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsService;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeService;
import net.sourceforge.atunes.model.AudioObject;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public final class ContextHandler
extends AbstractHandler
implements PluginListener,
PlayListEventListener {
    private static ContextHandler instance;
    private AudioObject currentAudioObject;
    private long lastAudioObjectModificationTime;
    private List<AbstractContextPanel> contextPanels;

    @Override
    protected void initHandler() {
        LastFmService.getInstance().updateService();
        LyricsService.getInstance().updateService();
        PlayListHandler.getInstance().addPlayListEventListener(this);
    }

    @Override
    public void applicationStarted() {
        GuiHandler.getInstance().getContextPanel().setSelectedIndex(ApplicationState.getInstance().getSelectedContextTab());
        GuiHandler.getInstance().getContextPanel().getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ContextHandler.this.contextPanelChanged();
            }
        });
    }

    public List<AbstractContextPanel> getContextPanels() {
        if (this.contextPanels == null) {
            this.contextPanels = new ArrayList<AbstractContextPanel>();
            this.contextPanels.add(new AudioObjectContextPanel());
            this.contextPanels.add(new AlbumContextPanel());
            this.contextPanels.add(new ArtistContextPanel());
            this.contextPanels.add(new SimilarArtistsContextPanel());
            this.contextPanels.add(new YoutubeContextPanel());
        }
        return this.contextPanels;
    }

    public static ContextHandler getInstance() {
        if (instance == null) {
            instance = new ContextHandler();
        }
        return instance;
    }

    private void contextPanelChanged() {
        ApplicationState.getInstance().setSelectedContextTab(GuiHandler.getInstance().getContextPanel().getSelectedIndex());
        this.retrieveInfo(this.currentAudioObject, false);
    }

    public void clearContextPanels() {
        this.clearTabsContent();
        this.currentAudioObject = null;
        ApplicationState.getInstance().setSelectedContextTab(0);
        GuiHandler.getInstance().getContextPanel().setSelectedIndex(ApplicationState.getInstance().getSelectedContextTab());
    }

    private void clearTabsContent() {
        for (AbstractContextPanel abstractContextPanel : this.getContextPanels()) {
            abstractContextPanel.clearContextPanel();
        }
    }

    public void retrieveInfoAndShowInPanel(AudioObject audioObject) {
        boolean bl = false;
        if (this.currentAudioObject != null && this.currentAudioObject.equals(audioObject)) {
            if (audioObject instanceof AudioFile) {
                if (((AudioFile)audioObject).getFile().lastModified() == this.lastAudioObjectModificationTime) {
                    return;
                }
                bl = true;
            } else if (!(audioObject instanceof Radio)) {
                return;
            }
        }
        this.currentAudioObject = audioObject;
        this.lastAudioObjectModificationTime = audioObject instanceof AudioFile ? ((AudioFile)audioObject).getFile().lastModified() : 0L;
        if (ApplicationState.getInstance().isUseContext()) {
            GuiHandler.getInstance().getContextPanel().updateContextTabsText();
            GuiHandler.getInstance().getContextPanel().updateContextTabsIcons();
            GuiHandler.getInstance().getContextPanel().enableContextTabs();
            if (audioObject == null) {
                this.clearContextPanels();
            } else {
                if (bl) {
                    this.clearTabsContent();
                }
                this.retrieveInfo(audioObject, true);
            }
        }
    }

    private void retrieveInfo(AudioObject audioObject, boolean bl) {
        if (audioObject == null) {
            return;
        }
        int n = ApplicationState.getInstance().getSelectedContextTab();
        if (n >= this.getContextPanels().size()) {
            n = 0;
        }
        this.getContextPanels().get(n).updateContextPanel(audioObject, bl);
    }

    @Override
    public void applicationFinish() {
        ContextHandler.getLogger().debug("HANDLER     ");
        LastFmService.getInstance().finishService();
        LyricsService.getInstance().finishService();
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        LastFmService.getInstance().updateService();
        LyricsService.getInstance().updateService();
        YoutubeService.getInstance().updateService();
    }

    public AudioObject getCurrentAudioObject() {
        return this.currentAudioObject;
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        try {
            AbstractContextPanel abstractContextPanel = (AbstractContextPanel)PluginsHandler.getInstance().getNewInstance(pluginInfo);
            this.getContextPanels().add(abstractContextPanel);
        }
        catch (PluginSystemException pluginSystemException) {
            ContextHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        for (Plugin plugin : collection) {
            this.getContextPanels().remove(plugin);
            GuiHandler.getInstance().getContextPanel().removeContextPanel((AbstractContextPanel)plugin);
        }
    }

    @Override
    public void selectedAudioObjectChanged(AudioObject audioObject) {
        if (ApplicationState.getInstance().isUseContext()) {
            this.retrieveInfoAndShowInPanel(audioObject);
        }
    }

    @Override
    public void clear() {
        if (ApplicationState.getInstance().isUseContext()) {
            this.retrieveInfoAndShowInPanel(null);
            if (ApplicationState.getInstance().isStopPlayerOnPlayListClear()) {
                ContextHandler.getInstance().clearContextPanels();
            }
        }
    }
}

