/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.album;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.TrackInfo;
import net.sourceforge.atunes.kernel.modules.context.album.AlbumInfoDataSource;
import net.sourceforge.atunes.kernel.modules.context.album.ContextTracksTableModel;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class AlbumTracksContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = -5538266144953409867L;
    private JTable tracksTable;

    public AlbumTracksContent() {
        super(new AlbumInfoDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("SONGS");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, AudioObject> hashMap = new HashMap<String, AudioObject>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map.containsKey("ALBUM")) {
            this.tracksTable.setModel(new ContextTracksTableModel((AlbumInfo)map.get("ALBUM")));
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.tracksTable.setModel(new ContextTracksTableModel(null));
    }

    @Override
    protected Component getComponent() {
        this.tracksTable = new JTable();
        this.tracksTable.setSelectionMode(0);
        this.tracksTable.setShowGrid(false);
        this.tracksTable.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        this.tracksTable.setDefaultRenderer(Integer.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        this.tracksTable.getTableHeader().setReorderingAllowed(true);
        this.tracksTable.getTableHeader().setResizingAllowed(false);
        this.tracksTable.setColumnModel(new TracksDefaultTableColumnModel());
        this.tracksTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = AlbumTracksContent.this.tracksTable.getSelectedRow()) != -1) {
                    TrackInfo trackInfo = ((ContextTracksTableModel)AlbumTracksContent.this.tracksTable.getModel()).getTrack(n);
                    DesktopUtils.openURL(trackInfo.getUrl());
                }
            }
        });
        return this.tracksTable;
    }

    private static class TracksDefaultTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1338172152164826400L;

        private TracksDefaultTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            super.addColumn(tableColumn);
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setMaxWidth(25);
            }
        }
    }
}

