/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.album;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.TrackInfo;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class ContextTracksTableModel
implements TableModel {
    private AlbumInfo album;
    private List<TableModelListener> listeners;

    public ContextTracksTableModel(AlbumInfo albumInfo) {
        this.album = albumInfo;
        this.listeners = new ArrayList<TableModelListener>();
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Integer.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return n != 0 ? I18nUtils.getString("SONGS") : "";
    }

    @Override
    public int getRowCount() {
        return this.album != null ? this.album.getTracks().size() : 0;
    }

    public TrackInfo getTrack(int n) {
        return this.album != null ? this.album.getTracks().get(n) : null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return StringUtils.getString(n + 1, ".");
        }
        return this.album != null ? this.album.getTracks().get(n).getTitle() : "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }
}

