/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.artist;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.ContextImageJTable;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistInfoDataSource;
import net.sourceforge.atunes.kernel.modules.context.artist.ContextAlbumsTableModel;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class ArtistAlbumsContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = -5538266144953409867L;
    private ContextImageJTable albumsTable;

    public ArtistAlbumsContent() {
        super(new ArtistInfoDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("ALBUMS");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        hashMap.put("ALBUMS", true);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map.containsKey("ALBUMS")) {
            this.albumsTable.setModel(new ContextAlbumsTableModel((List)map.get("ALBUMS")));
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.albumsTable.setModel(new ContextAlbumsTableModel(null));
    }

    @Override
    protected Component getComponent() {
        this.albumsTable = new ContextImageJTable();
        this.albumsTable.setSelectionMode(0);
        this.albumsTable.setShowGrid(false);
        this.albumsTable.getTableHeader().setReorderingAllowed(false);
        this.albumsTable.getTableHeader().setResizingAllowed(false);
        this.albumsTable.setDefaultRenderer(AlbumInfo.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new AlbumsTableCellRendererCode()));
        this.albumsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = ArtistAlbumsContent.this.albumsTable.getSelectedRow()) != -1) {
                    AlbumInfo albumInfo = ((ContextAlbumsTableModel)ArtistAlbumsContent.this.albumsTable.getModel()).getAlbum(n);
                    DesktopUtils.openURL(albumInfo.getUrl());
                }
            }
        });
        return this.albumsTable;
    }

    private static class AlbumsTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private AlbumsTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return ArtistAlbumsContent.getPanelForTableRenderer(((AlbumInfo)object).getCover(), StringUtils.getString("<html>", ((AlbumInfo)object).getTitle(), "</html>"), component.getBackground(), 75, 75);
        }
    }
}

