/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.audioobject;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class LyricsDataSource
implements ContextInformationDataSource {
    public static final String INPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_LYRIC = "LYRIC";
    public static final String OUTPUT_AUDIO_OBJECT = "AUDIO_OBJECT";

    @Override
    public Map<String, ?> getData(Map<String, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map.containsKey("AUDIO_OBJECT")) {
            AudioObject audioObject = (AudioObject)map.get("AUDIO_OBJECT");
            hashMap.put("AUDIO_OBJECT", audioObject);
            hashMap.put(OUTPUT_LYRIC, this.getLyrics(audioObject));
        }
        return hashMap;
    }

    private Lyrics getLyrics(AudioObject audioObject) {
        Lyrics lyrics = null;
        if (!audioObject.getLyrics().trim().isEmpty()) {
            lyrics = new Lyrics(audioObject.getLyrics(), null);
        } else if (!(audioObject.getTitle().trim().isEmpty() || audioObject.getArtist().trim().isEmpty() || audioObject.getArtist().equals(I18nUtils.getString("UNKNOWN_ARTIST")))) {
            lyrics = LyricsService.getInstance().getLyrics(audioObject.getArtist().trim(), audioObject.getTitle().trim());
        }
        if (lyrics == null) {
            lyrics = new Lyrics("", "");
        }
        return lyrics;
    }
}

