/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.similar;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.utils.I18nUtils;

public class SimilarArtistsTableModel
implements TableModel {
    private List<ArtistInfo> artists;
    private List<TableModelListener> listeners;

    public SimilarArtistsTableModel(List<ArtistInfo> list) {
        this.artists = list;
        this.listeners = new ArrayList<TableModelListener>();
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public ArtistInfo getArtist(int n) {
        return this.artists.get(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ArtistInfo.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nUtils.getString("SIMILAR_ARTISTS");
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.artists != null ? this.artists.size() : 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.artists.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }
}

