/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.device;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.device.DeviceConnectionListener;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;

public final class DeviceConnectionMonitor
extends Thread {
    private static DeviceConnectionMonitor instance;
    private static List<DeviceConnectionListener> listeners;
    private static int TIME_TO_WAIT;
    private Logger logger;

    private DeviceConnectionMonitor() {
    }

    public static void addListener(DeviceConnectionListener deviceConnectionListener) {
        listeners.add(deviceConnectionListener);
    }

    public static synchronized void startMonitor() {
        if (instance == null) {
            instance = new DeviceConnectionMonitor();
            instance.start();
        }
    }

    public static synchronized void stopMonitor() {
        if (instance != null) {
            instance.interrupt();
            instance = null;
        }
    }

    @Override
    public void run() {
        super.run();
        while (!this.isInterrupted()) {
            String string = ApplicationState.getInstance().getDefaultDeviceLocation();
            if (string != null && !string.equals("")) {
                File file = new File(string);
                if (!DeviceHandler.getInstance().isDeviceConnected() && file.exists()) {
                    this.getLogger().info("PROCESS     ", "Device connected");
                    for (DeviceConnectionListener deviceConnectionListener : listeners) {
                        SwingUtilities.invokeLater(new DeviceConnectedRunnable(deviceConnectionListener, string));
                    }
                    instance = null;
                    return;
                }
            }
            try {
                Thread.sleep(TIME_TO_WAIT);
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().error("PROCESS     ", interruptedException);
            }
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    static {
        listeners = new ArrayList<DeviceConnectionListener>();
        TIME_TO_WAIT = 5000;
    }

    private static class DeviceConnectedRunnable
    implements Runnable {
        private DeviceConnectionListener listener;
        private String deviceLocation;

        public DeviceConnectedRunnable(DeviceConnectionListener deviceConnectionListener, String string) {
            this.listener = deviceConnectionListener;
            this.deviceLocation = string;
        }

        @Override
        public void run() {
            this.listener.deviceConnected(this.deviceLocation);
        }
    }
}

