/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.device;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.device.DeviceDisconnectionListener;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.misc.log.Logger;

public final class DeviceDisconnectionMonitor
extends Thread {
    private static DeviceDisconnectionMonitor instance;
    private static List<DeviceDisconnectionListener> listeners;
    private static int TIME_TO_WAIT;
    private Logger logger;

    private DeviceDisconnectionMonitor() {
    }

    public static void addListener(DeviceDisconnectionListener deviceDisconnectionListener) {
        listeners.add(deviceDisconnectionListener);
    }

    public static void startMonitor() {
        if (instance == null) {
            instance = new DeviceDisconnectionMonitor();
            instance.start();
        }
    }

    public static void stopMonitor() {
        if (instance != null) {
            instance.interrupt();
            instance = null;
        }
    }

    @Override
    public void run() {
        super.run();
        while (!this.isInterrupted()) {
            if (!DeviceHandler.getInstance().isDeviceConnected()) {
                return;
            }
            File file = DeviceHandler.getInstance().getDeviceRepository().getFolders().get(0);
            if (!file.exists()) {
                this.getLogger().info("PROCESS     ", "Device disconnected");
                for (DeviceDisconnectionListener deviceDisconnectionListener : listeners) {
                    SwingUtilities.invokeLater(new DeviceDisconnectedRunnable(deviceDisconnectionListener, file.getAbsolutePath()));
                }
                return;
            }
            try {
                Thread.sleep(TIME_TO_WAIT);
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().error("PROCESS     ", interruptedException);
            }
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    static {
        listeners = new ArrayList<DeviceDisconnectionListener>();
        TIME_TO_WAIT = 5000;
    }

    private static class DeviceDisconnectedRunnable
    implements Runnable {
        private DeviceDisconnectionListener listener;
        private String deviceLocation;

        public DeviceDisconnectedRunnable(DeviceDisconnectionListener deviceDisconnectionListener, String string) {
            this.listener = deviceDisconnectionListener;
            this.deviceLocation = string;
        }

        @Override
        public void run() {
            this.listener.deviceDisconnected(this.deviceLocation);
        }
    }
}

