/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.draganddrop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.gui.model.TransferableList;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.draganddrop.PlayListDragableRow;
import net.sourceforge.atunes.kernel.modules.navigator.DeviceNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.log.Logger;

public class PlayListToDeviceDragAndDropListener
implements DropTargetListener {
    private Logger logger;

    public PlayListToDeviceDragAndDropListener() {
        new DropTarget(NavigationHandler.getInstance().getView(DeviceNavigationView.class).getTreeScrollPane(), this);
        new DropTarget(NavigationHandler.getInstance().getView(DeviceNavigationView.class).getTree(), this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(dataFlavor = new TransferableList(null).getTransferDataFlavors()[0])) {
            dropTargetDropEvent.acceptDrop(1);
            try {
                List list = (List)transferable.getTransferData(dataFlavor);
                if (DeviceHandler.getInstance().isDeviceConnected()) {
                    ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
                    for (PlayListDragableRow playListDragableRow : list) {
                        if (!(playListDragableRow.getRowContent() instanceof AudioFile) || DeviceHandler.getInstance().isDevicePath(playListDragableRow.getRowContent().getUrl())) continue;
                        arrayList.add((AudioFile)playListDragableRow.getRowContent());
                    }
                    if (!arrayList.isEmpty()) {
                        DeviceHandler.getInstance().copyFilesToDevice(arrayList);
                    }
                }
            }
            catch (Exception exception) {
                this.getLogger().internalError(exception);
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

