/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.filter;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.filter.AbstractFilter;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class FilterHandler
extends AbstractHandler {
    private static FilterHandler instance;
    private Map<String, AbstractFilter> filters;
    private AbstractFilter allFilter = new AllFilter();
    private String selectedFilter = this.allFilter.getName();
    private String currentFilterText;

    private FilterHandler() {
        this.filters = new HashMap<String, AbstractFilter>();
    }

    @Override
    protected void initHandler() {
    }

    public static FilterHandler getInstance() {
        if (instance == null) {
            instance = new FilterHandler();
        }
        return instance;
    }

    private void addFilter(AbstractFilter abstractFilter) {
        this.filters.put(abstractFilter.getName(), abstractFilter);
        ControllerProxy.getInstance().getToolBarFilterController().addFilter(abstractFilter);
    }

    public void removeFilter(AbstractFilter abstractFilter) {
        this.filters.remove(abstractFilter.getName());
        ControllerProxy.getInstance().getToolBarFilterController().removeFilter(abstractFilter.getName());
    }

    public void applyFilter(String string) {
        this.currentFilterText = string;
        FilterHandler.getLogger().debug("HANDLER     ", "Applying filter: ", string);
        this.filters.get(this.selectedFilter).applyFilter(string);
    }

    @Override
    public void applicationStarted() {
        this.addFilter(this.allFilter);
        this.addFilter(NavigationHandler.getInstance().getTreeFilter());
        this.setFilterEnabled(NavigationHandler.getInstance().getTreeFilter(), ApplicationState.getInstance().isShowNavigationTree());
        this.addFilter(NavigationHandler.getInstance().getTableFilter());
        this.setFilterEnabled(NavigationHandler.getInstance().getTableFilter(), ApplicationState.getInstance().isShowNavigationTable());
        this.addFilter(PlayListHandler.getInstance().getPlayListFilter());
        ControllerProxy.getInstance().getToolBarFilterController().setSelectedFilter(this.allFilter.getName());
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    public void setSelectedFilter(String string) {
        this.selectedFilter = string;
    }

    public String getFilter() {
        return this.currentFilterText;
    }

    public boolean isFilterSelected(AbstractFilter abstractFilter) {
        return (this.selectedFilter.equals(this.allFilter.getName()) || this.selectedFilter.equals(abstractFilter.getName())) && this.getFilter() != null;
    }

    public void setFilterEnabled(AbstractFilter abstractFilter, boolean bl) {
        if (this.selectedFilter.equals(abstractFilter.getName()) && !bl) {
            this.selectedFilter = this.allFilter.getName();
            ControllerProxy.getInstance().getToolBarFilterController().setSelectedFilter(this.allFilter.getName());
            this.applyFilter(null);
        }
        ControllerProxy.getInstance().getToolBarFilterController().setFilterEnabled(abstractFilter.getName(), bl);
    }

    private final class AllFilter
    extends AbstractFilter {
        private AllFilter() {
        }

        @Override
        public String getName() {
            return "ALL";
        }

        @Override
        public String getDescription() {
            return I18nUtils.getString("ALL");
        }

        @Override
        public void applyFilter(String string) {
            for (AbstractFilter abstractFilter : FilterHandler.this.filters.values()) {
                if (abstractFilter.equals(this)) continue;
                abstractFilter.applyFilter(string);
            }
        }
    }
}

