/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.filter.AbstractFilter;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.DeviceNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.FavoritesNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.RadioNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.RepositoryNavigationView;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public final class NavigationHandler
extends AbstractHandler
implements PluginListener {
    private static NavigationHandler instance;
    private List<AbstractNavigationView> navigationViews;
    private AbstractFilter tableFilter = new AbstractFilter(){

        @Override
        public String getName() {
            return "NAVIGATION_TABLE";
        }

        @Override
        public String getDescription() {
            return I18nUtils.getString("NAVIGATION_TABLE");
        }

        @Override
        public void applyFilter(String string) {
            ControllerProxy.getInstance().getNavigationController().updateTableContent(NavigationHandler.this.getCurrentView().getTree());
        }
    };
    private AbstractFilter treeFilter = new AbstractFilter(){

        @Override
        public String getName() {
            return "NAVIGATION_TREE";
        }

        @Override
        public String getDescription() {
            return I18nUtils.getString("NAVIGATOR");
        }

        @Override
        public void applyFilter(String string) {
            NavigationHandler.this.refreshCurrentView();
        }
    };

    public static NavigationHandler getInstance() {
        if (instance == null) {
            instance = new NavigationHandler();
        }
        return instance;
    }

    private NavigationHandler() {
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    protected void initHandler() {
    }

    @Override
    public void applicationStarted() {
    }

    public List<AbstractNavigationView> getNavigationViews() {
        if (this.navigationViews == null) {
            this.navigationViews = new ArrayList<AbstractNavigationView>();
            this.navigationViews.add(new RepositoryNavigationView());
            this.navigationViews.add(new FavoritesNavigationView());
            this.navigationViews.add(new DeviceNavigationView());
            this.navigationViews.add(new RadioNavigationView());
            this.navigationViews.add(new PodcastNavigationView());
        }
        return this.navigationViews;
    }

    private Map<Class<? extends AbstractNavigationView>, AbstractNavigationView> getNavigationViewsMap() {
        HashMap<Class<? extends AbstractNavigationView>, AbstractNavigationView> hashMap = new HashMap<Class<? extends AbstractNavigationView>, AbstractNavigationView>();
        for (AbstractNavigationView abstractNavigationView : this.getNavigationViews()) {
            hashMap.put(abstractNavigationView.getClass(), abstractNavigationView);
        }
        return hashMap;
    }

    public AbstractNavigationView getCurrentView() {
        return this.getView(this.getViewByName(ApplicationState.getInstance().getNavigationView()));
    }

    public NavigationController.ViewMode getCurrentViewMode() {
        return this.getCurrentView().getCurrentViewMode();
    }

    public AbstractNavigationView getView(Class<? extends AbstractNavigationView> clazz) {
        return this.getNavigationViewsMap().get(clazz);
    }

    public void refreshCurrentView() {
        this.getCurrentView().refreshView(ApplicationState.getInstance().getViewMode(), FilterHandler.getInstance().isFilterSelected(this.getTreeFilter()) ? FilterHandler.getInstance().getFilter() : null);
    }

    public void refreshView(Class<? extends AbstractNavigationView> clazz) {
        if (this.getView(clazz).equals(this.getCurrentView())) {
            this.getView(clazz).refreshView(ApplicationState.getInstance().getViewMode(), FilterHandler.getInstance().isFilterSelected(this.getTreeFilter()) ? FilterHandler.getInstance().getFilter() : null);
        }
    }

    public Class<? extends AbstractNavigationView> getViewByName(String string) {
        if (string == null) {
            return null;
        }
        for (Class<? extends AbstractNavigationView> clazz : this.getNavigationViewsMap().keySet()) {
            if (!clazz.getName().equals(string)) continue;
            return clazz;
        }
        return RepositoryNavigationView.class;
    }

    public int indexOf(Class<? extends AbstractNavigationView> clazz) {
        return this.getNavigationViews().indexOf(this.getNavigationViewsMap().get(clazz));
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        try {
            this.getNavigationViews().add((AbstractNavigationView)PluginsHandler.getInstance().getNewInstance(pluginInfo));
            ControllerProxy.getInstance().getNavigationController().getNavigationTreePanel().updateTabs();
        }
        catch (PluginSystemException pluginSystemException) {
            NavigationHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        for (Plugin plugin : collection) {
            this.getNavigationViews().remove(plugin);
        }
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.refreshView(RadioNavigationView.class);
        this.refreshCurrentView();
    }

    public AbstractFilter getTableFilter() {
        return this.tableFilter;
    }

    public AbstractFilter getTreeFilter() {
        return this.treeFilter;
    }
}

