/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.notify;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.kernel.modules.notify.Notifications;
import net.sourceforge.atunes.kernel.modules.notify.Notify;
import net.sourceforge.atunes.misc.TempFolder;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.ImageUtils;

public class LibnotifyNotifications
implements Notifications {
    private Logger logger;
    private ExecutorService executorService;
    private boolean available = false;

    public LibnotifyNotifications() {
        if (!Notify.isNotifyPresent()) {
            this.getLogger().error("NOTIFICATIONS", "libnotify is not available");
            return;
        }
        if (!Notify.init("aTunes")) {
            this.getLogger().error("NOTIFICATIONS", "could not init libnotify");
            return;
        }
        this.executorService = Executors.newSingleThreadExecutor();
        this.available = true;
    }

    @Override
    public String getName() {
        return "libnotify";
    }

    @Override
    public void showNotification(AudioObject audioObject) {
        ShowNotificationRunnable showNotificationRunnable = new ShowNotificationRunnable(audioObject);
        this.executorService.execute(showNotificationRunnable);
    }

    @Override
    public void disposeNotifications() {
        Notify.uninit();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class ShowNotificationRunnable
    implements Runnable {
        private final AudioObject audioObject;

        private ShowNotificationRunnable(AudioObject audioObject) {
            this.audioObject = audioObject;
        }

        @Override
        public void run() {
            if (LibnotifyNotifications.this.available) {
                ImageIcon imageIcon = this.audioObject.getImage(ImageSize.SIZE_200);
                if (imageIcon == null) {
                    imageIcon = this.audioObject.getGenericImage(GenericImageSize.MEDIUM);
                }
                String string = TempFolder.getInstance().writeImageToTempFolder(ImageUtils.toBufferedImage(imageIcon.getImage()), UUID.randomUUID().toString()).getAbsolutePath();
                Notify.NotifyNotification notifyNotification = Notify.newNotification(this.audioObject.getTitle(), this.audioObject.getArtist(), string);
                if (!Notify.show(notifyNotification)) {
                    LibnotifyNotifications.this.getLogger().error("NOTIFICATIONS", "could not show notification - libnotify");
                }
            } else {
                LibnotifyNotifications.this.getLogger().error("NOTIFICATIONS", "libnotify is not available or could not be initialized");
            }
        }
    }
}

