/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.notify;

import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.modules.notify.DefaultNotifications;
import net.sourceforge.atunes.kernel.modules.notify.LibnotifyNotifications;
import net.sourceforge.atunes.kernel.modules.notify.Notifications;
import net.sourceforge.atunes.kernel.modules.player.PlaybackState;
import net.sourceforge.atunes.kernel.modules.player.PlaybackStateListener;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;

public final class NotifyHandler
extends AbstractHandler
implements PlaybackStateListener {
    private static NotifyHandler instance;
    private Notifications notifications;

    private NotifyHandler() {
    }

    @Override
    public void applicationFinish() {
        this.notifications.disposeNotifications();
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.notifications = applicationState.isUseLibnotify() ? new LibnotifyNotifications() : new DefaultNotifications();
    }

    @Override
    protected void initHandler() {
        ApplicationState applicationState = ApplicationState.getInstance();
        this.notifications = applicationState.isUseLibnotify() ? new LibnotifyNotifications() : new DefaultNotifications();
    }

    public static NotifyHandler getInstance() {
        if (instance == null) {
            instance = new NotifyHandler();
        }
        return instance;
    }

    @Override
    public void applicationStarted() {
    }

    public void showNotification(AudioObject audioObject) {
        this.notifications.showNotification(audioObject);
    }

    @Override
    public void playbackStateChanged(PlaybackState playbackState, AudioObject audioObject) {
        if (ApplicationState.getInstance().isShowOSD() && playbackState == PlaybackState.PLAYING) {
            this.showNotification(audioObject);
        }
    }
}

