/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListAudioObject;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListChangedListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListMode;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.PointedList;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class PlayList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2756513776762920794L;
    private transient List<PlayListChangedListener> listeners;
    private transient PlayListMode mode;
    private String name;
    private transient boolean dirty;
    private PointedList<AudioObject> audioObjects = new PlayListPointedList();

    protected PlayList() {
        this((List<AudioObject>)null);
    }

    protected PlayList(List<AudioObject> list) {
        this.mode = PlayListMode.getPlayListMode(this);
        if (list != null) {
            this.add(list);
        }
    }

    private PlayList(PlayList playList) {
        this.name = playList.name == null ? null : playList.name;
        this.audioObjects = new PlayListPointedList(playList.audioObjects);
        this.mode = PlayListMode.getPlayListMode(this);
    }

    protected void add(AudioObject audioObject) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        arrayList.add(audioObject);
        this.add(arrayList);
    }

    private void add(List<? extends AudioObject> list) {
        int n = this.audioObjects.size();
        this.add(n, list);
    }

    protected void add(int n, AudioObject audioObject) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        arrayList.add(audioObject);
        this.add(n, arrayList);
    }

    protected void add(int n, List<? extends AudioObject> list) {
        this.audioObjects.addAll(n, list);
        this.notifyAudioObjectsAdded(n, list);
    }

    protected void remove(int n) {
        AudioObject audioObject = this.get(n);
        if (audioObject != null) {
            PlayListAudioObject playListAudioObject = new PlayListAudioObject();
            playListAudioObject.setPosition(n);
            playListAudioObject.setAudioObject(audioObject);
            ArrayList<PlayListAudioObject> arrayList = new ArrayList<PlayListAudioObject>();
            arrayList.add(playListAudioObject);
            this.audioObjects.remove(n);
            this.notifyAudioObjectsRemoved(arrayList);
        }
    }

    protected void remove(List<AudioObject> list) {
        ArrayList<PlayListAudioObject> arrayList = new ArrayList<PlayListAudioObject>();
        for (AudioObject object : list) {
            List<AudioObject> list2 = new ArrayList<AudioObject>(this.audioObjects.getList());
            while (list2.indexOf(object) != -1) {
                int n = list2.indexOf(object);
                PlayListAudioObject playListAudioObject = new PlayListAudioObject();
                playListAudioObject.setPosition(n);
                playListAudioObject.setAudioObject(object);
                arrayList.add(playListAudioObject);
                list2 = list2.subList(n + 1, list2.size());
            }
        }
        Collections.sort(arrayList, new PlayListAudioObjectComparator());
        for (PlayListAudioObject playListAudioObject : arrayList) {
            this.audioObjects.remove(playListAudioObject.getPosition());
        }
        this.notifyAudioObjectsRemoved(arrayList);
    }

    protected void clear() {
        this.audioObjects.clear();
        this.notifyAudioObjectsRemovedAll();
    }

    protected void replace(int n, AudioObject audioObject) {
        this.audioObjects.replace(n, audioObject);
    }

    protected void moveRowTo(int n, int n2) {
        if (n < 0 || n >= this.size()) {
            throw new IllegalArgumentException(StringUtils.getString("sourceRow = ", n, " playlist size = ", this.size()));
        }
        if (n2 < 0 || n2 >= this.size()) {
            throw new IllegalArgumentException(StringUtils.getString("targetRow = ", n2, " playlist size = ", this.size()));
        }
        AudioObject audioObject = this.get(n);
        boolean bl = this.audioObjects.getPointer() == n;
        this.remove(n);
        this.add(n2, audioObject);
        if (bl) {
            this.audioObjects.setPointer(n2);
        }
    }

    protected void sort(Comparator<AudioObject> comparator) {
        this.audioObjects.sort(comparator);
        this.setDirty(true);
    }

    protected void shuffle() {
        this.audioObjects.shuffle();
        this.updateUI();
        this.setDirty(true);
    }

    public int indexOf(AudioObject audioObject) {
        return this.audioObjects.indexOf(audioObject);
    }

    public int size() {
        return this.audioObjects.size();
    }

    public boolean isEmpty() {
        return this.audioObjects.isEmpty();
    }

    public AudioObject get(int n) {
        if (n < 0 || n >= this.audioObjects.size()) {
            return null;
        }
        return this.audioObjects.get(n);
    }

    protected AudioObject getCurrentAudioObject() {
        return this.audioObjects.getCurrentObject();
    }

    protected void setCurrentAudioObjectIndex(int n) {
        this.audioObjects.setPointer(n);
        this.updateUI();
    }

    protected void updateUI() {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new UpdateUIRunnable());
        } else {
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
            ControllerProxy.getInstance().getPlayListController().scrollPlayList(false);
        }
    }

    protected int getCurrentAudioObjectIndex() {
        return this.audioObjects.getPointer() != null ? this.audioObjects.getPointer() : 0;
    }

    public List<AudioObject> getObjectsOfType(Class<? extends AudioObject> clazz) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (AudioObject audioObject : this.audioObjects.getList()) {
            if (!audioObject.getClass().equals(clazz)) continue;
            arrayList.add(audioObject);
        }
        return arrayList;
    }

    public boolean contains(AudioObject audioObject) {
        return this.audioObjects.contains(audioObject);
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected int getRandomPosition() {
        return new Random(System.currentTimeMillis()).nextInt(this.audioObjects.size());
    }

    protected PlayList clone() {
        return new PlayList(this);
    }

    protected AudioObject moveToNextAudioObject() {
        AudioObject audioObject = this.getMode().moveToNextAudioObject();
        this.updateUI();
        return audioObject;
    }

    protected AudioObject moveToPreviousAudioObject() {
        AudioObject audioObject = this.getMode().moveToPreviousAudioObject();
        this.updateUI();
        return audioObject;
    }

    public AudioObject getNextAudioObject(int n) {
        return this.getMode().getNextAudioObject(n);
    }

    public AudioObject getPreviousAudioObject(int n) {
        return this.getMode().getPreviousAudioObject(n);
    }

    public String getLength() {
        long l = 0L;
        for (AudioObject audioObject : this.audioObjects.getList()) {
            l += (long)audioObject.getDuration();
        }
        return StringUtils.fromSecondsToHoursAndDays(l);
    }

    protected List<AudioObject> getAudioObjects() {
        return this.audioObjects.getList();
    }

    protected void addPlayListChangedListener(PlayListChangedListener playListChangedListener) {
        this.getListeners().add(playListChangedListener);
    }

    protected void removePlayListChangedListener(PlayListChangedListener playListChangedListener) {
        this.getListeners().remove(playListChangedListener);
    }

    private void notifyAudioObjectsAdded(int n, List<? extends AudioObject> list) {
        List<PlayListAudioObject> list2 = PlayListAudioObject.getList(n, list);
        for (PlayListChangedListener playListChangedListener : this.getListeners()) {
            playListChangedListener.audioObjectsAdded(list2);
        }
        this.getMode().audioObjectsAdded(list2);
        this.setDirty(true);
    }

    private void notifyAudioObjectsRemoved(List<PlayListAudioObject> list) {
        for (PlayListChangedListener playListChangedListener : this.getListeners()) {
            playListChangedListener.audioObjectsRemoved(list);
        }
        this.getMode().audioObjectsRemoved(list);
        this.setDirty(true);
    }

    private void notifyAudioObjectsRemovedAll() {
        for (PlayListChangedListener playListChangedListener : this.getListeners()) {
            playListChangedListener.audioObjectsRemovedAll();
        }
        this.getMode().audioObjectsRemovedAll();
        this.setDirty(true);
    }

    private List<PlayListChangedListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PlayListChangedListener>();
        }
        return this.listeners;
    }

    protected PlayListMode getMode() {
        return this.mode;
    }

    protected void setMode(PlayListMode playListMode) {
        this.mode = playListMode;
    }

    PointedList<AudioObject> getPointedList() {
        return this.audioObjects;
    }

    void addToPlaybackHistory(AudioObject audioObject) {
        this.mode.addToPlaybackHistory(audioObject);
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean bl) {
        this.dirty = bl;
    }

    protected void setContent(List<AudioObject> list) {
        this.audioObjects.setContent(list);
        this.notifyAudioObjectsAdded(0, list);
        this.setDirty(false);
    }

    static class PlayListPointedList
    extends PointedList<AudioObject> {
        private static final long serialVersionUID = -6966402482637754615L;

        PlayListPointedList() {
        }

        PlayListPointedList(PointedList<AudioObject> pointedList) {
            super(pointedList);
        }

        @Override
        public boolean isCyclic() {
            return ApplicationState.getInstance().isRepeat();
        }
    }

    private static class PlayListAudioObjectComparator
    implements Comparator<PlayListAudioObject> {
        private PlayListAudioObjectComparator() {
        }

        @Override
        public int compare(PlayListAudioObject playListAudioObject, PlayListAudioObject playListAudioObject2) {
            return -Integer.valueOf(playListAudioObject.getPosition()).compareTo(playListAudioObject2.getPosition());
        }
    }

    private static class UpdateUIRunnable
    implements Runnable {
        private UpdateUIRunnable() {
        }

        @Override
        public void run() {
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
            ControllerProxy.getInstance().getPlayListController().scrollPlayList(false);
        }
    }
}

