/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class PlayListIO {
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String M3U_START_COMMENT = "#";
    private static final String M3U_UNIX_ABSOLUTE_PATH = "/";
    private static final String M3U_WINDOWS_ABSOLUTE_PATH = ":\\";
    private static final String M3U_UNC_ABSOLUTE_PATH = "\\\\";
    public static final String M3U_FILE_EXTENSION = "m3u";
    private static final String M3U_HTTP_PREFIX = "http://";

    private PlayListIO() {
    }

    public static List<AudioObject> getAudioObjectsFromFileNamesList(List<String> list) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (String string : list) {
            arrayList.add(PlayListIO.getAudioFileOrCreate(string));
        }
        return arrayList;
    }

    static AudioObject getAudioFileOrCreate(String string) {
        Comparable<Radio> comparable = null;
        if (string.startsWith(M3U_HTTP_PREFIX)) {
            comparable = RadioHandler.getInstance().getRadioIfLoaded(string);
            if (comparable == null) {
                comparable = new Radio(string, string, null);
            }
            return comparable;
        }
        comparable = RepositoryHandler.getInstance().getFileIfLoaded(string);
        if (comparable == null) {
            comparable = new AudioFile(string);
        }
        return comparable;
    }

    public static List<AudioObject> getFilesFromList(File file) {
        List<String> list = PlayListIO.read(file);
        return PlayListIO.getAudioObjectsFromFileNamesList(list);
    }

    public static final FileFilter getPlaylistFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(PlayListIO.M3U_FILE_EXTENSION);
            }

            @Override
            public String getDescription() {
                return I18nUtils.getString("PLAYLIST");
            }
        };
    }

    public static boolean isValidPlayList(String string) {
        File file = new File(string);
        return string.endsWith(M3U_FILE_EXTENSION) && file.exists();
    }

    public static boolean isValidPlayList(File file) {
        return file.getName().endsWith(M3U_FILE_EXTENSION) && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> read(File file) {
        Object object;
        BufferedReader bufferedReader = null;
        try {
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((object = bufferedReader.readLine()) != null && ((String)object).startsWith(M3U_START_COMMENT)) {
            }
            if (object == null) {
                List<String> list = Collections.emptyList();
                ClosingUtils.close(bufferedReader);
                return list;
            }
            if (((String)object).startsWith(M3U_WINDOWS_ABSOLUTE_PATH, 1) || ((String)object).startsWith(M3U_UNIX_ABSOLUTE_PATH) || ((String)object).startsWith(M3U_UNC_ABSOLUTE_PATH)) {
                if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS && ((String)object).startsWith(M3U_UNIX_ABSOLUTE_PATH) || SystemProperties.OS != SystemProperties.OperatingSystem.WINDOWS && ((String)object).startsWith(M3U_WINDOWS_ABSOLUTE_PATH, 1)) {
                    List<String> list = Collections.emptyList();
                    ClosingUtils.close(bufferedReader);
                    return list;
                }
                arrayList.add(object);
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)object).startsWith(M3U_START_COMMENT) || ((String)object).isEmpty()) continue;
                    arrayList.add(object);
                }
            } else {
                object2 = file.getParent() + SystemProperties.FILE_SEPARATOR;
                arrayList.add(((String)object).startsWith(M3U_HTTP_PREFIX) ? object : StringUtils.getString(object2, object));
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)object).startsWith(M3U_START_COMMENT) || ((String)object).isEmpty()) continue;
                    arrayList.add(((String)object).startsWith(M3U_HTTP_PREFIX) ? object : StringUtils.getString(object2, object));
                }
            }
            object2 = arrayList;
            ClosingUtils.close(bufferedReader);
            return object2;
        }
        catch (IOException iOException) {
            object = Collections.emptyList();
            return object;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(PlayList playList, File file) {
        FileWriter fileWriter = null;
        try {
            if (file.exists()) {
                file.delete();
            }
            fileWriter = new FileWriter(file);
            fileWriter.append(StringUtils.getString(M3U_HEADER, SystemProperties.LINE_TERMINATOR));
            for (AudioObject audioObject : playList.getAudioObjects()) {
                fileWriter.append(StringUtils.getString(audioObject.getUrl(), SystemProperties.LINE_TERMINATOR));
            }
            fileWriter.flush();
            boolean bl = true;
            ClosingUtils.close(fileWriter);
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            ClosingUtils.close(fileWriter);
        }
    }
}

