/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public class Artist
implements Serializable,
TreeObject,
Comparable<Artist> {
    private static final long serialVersionUID = -7981636660798555640L;
    private String name;
    private Map<String, Album> albums;

    public Artist(String string) {
        this.name = string;
        this.albums = new HashMap<String, Album>();
    }

    public void addAlbum(Album album) {
        this.albums.put(album.getName(), album);
    }

    @Override
    public int compareTo(Artist artist) {
        return this.name.compareTo(artist.name);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Artist)) {
            return false;
        }
        return ((Artist)object).name.equals(this.name);
    }

    public Album getAlbum(String string) {
        return this.albums.get(string);
    }

    public Map<String, Album> getAlbums() {
        return this.albums;
    }

    public List<AudioFile> getAudioFiles() {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Album album : this.albums.values()) {
            arrayList.addAll(album.getAudioFiles());
        }
        return arrayList;
    }

    @Override
    public List<AudioObject> getAudioObjects() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (Album album : this.albums.values()) {
            arrayList.addAll(album.getAudioObjects());
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void removeAlbum(Album album) {
        this.albums.remove(album.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getToolTip() {
        int n = this.getAlbums().size();
        return StringUtils.getString(this.getName(), " (", n, " ", n > 1 ? I18nUtils.getString("ALBUMS") : I18nUtils.getString("ALBUM"), ")");
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return true;
    }

    @Override
    public void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
        extendedToolTip.setLine1(this.name);
        int n = this.albums.size();
        extendedToolTip.setLine2(StringUtils.getString(n, " ", n > 1 ? I18nUtils.getString("ALBUMS") : I18nUtils.getString("ALBUM")));
        Integer n2 = StatisticsHandler.getInstance().getArtistTimesPlayed(this);
        extendedToolTip.setLine3(StringUtils.getString(I18nUtils.getString("TIMES_PLAYED"), ": ", n2));
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        Image image = LastFmService.getInstance().getImage(this.name);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return true;
    }

    public static String getUnknownArtist() {
        return I18nUtils.getString("UNKNOWN_ARTIST");
    }

    public boolean isUnknownArtist() {
        return this.getName().equalsIgnoreCase(Artist.getUnknownArtist());
    }

    public static boolean isUnknownArtist(String string) {
        return Artist.getUnknownArtist().equalsIgnoreCase(string);
    }
}

