/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.RepositoryStructure;
import net.sourceforge.atunes.kernel.modules.repository.data.Year;
import net.sourceforge.atunes.kernel.modules.repository.exception.InconsistentRepositoryException;

public class Repository
implements Serializable {
    private static final long serialVersionUID = -8278937514875788175L;
    private List<File> folders;
    private Map<String, AudioFile> files;
    private long totalSizeInBytes;
    private long totalDurationInSeconds;
    private RepositoryStructure structure;
    private transient boolean dirty;

    public Repository(List<File> list) {
        this.folders = list;
        this.files = new HashMap<String, AudioFile>();
        this.structure = new RepositoryStructure();
    }

    public void addDurationInSeconds(long l) {
        this.totalDurationInSeconds += l;
    }

    public int countFiles() {
        return this.files.size();
    }

    public AudioFile getFile(String string) {
        return this.files.get(string);
    }

    public Map<String, AudioFile> getAudioFiles() {
        return this.files;
    }

    public List<AudioFile> getAudioFilesList() {
        return new ArrayList<AudioFile>(this.files.values());
    }

    public List<File> getFolders() {
        return new ArrayList<File>(this.folders);
    }

    public Map<String, Artist> getArtistStructure() {
        return this.structure.getArtistStructure();
    }

    public Map<String, Folder> getFolderStructure() {
        return this.structure.getFolderStructure();
    }

    public Map<String, Genre> getGenreStructure() {
        return this.structure.getGenreStructure();
    }

    public Map<String, Year> getYearStructure() {
        return this.structure.getYearStructure();
    }

    public long getTotalDurationInSeconds() {
        return this.totalDurationInSeconds;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void removeDurationInSeconds(long l) {
        this.totalDurationInSeconds -= l;
    }

    public void setTotalSizeInBytes(long l) {
        this.totalSizeInBytes = l;
    }

    public boolean exists() {
        return this.getFolders().get(0).exists();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void validateRepository() throws InconsistentRepositoryException {
        if (this.getAudioFiles() == null || this.getFolders() == null || this.getArtistStructure() == null || this.getFolderStructure() == null || this.getGenreStructure() == null || this.getYearStructure() == null) {
            throw new InconsistentRepositoryException();
        }
    }
}

