/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.favorites;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;

public class Favorites
implements Serializable {
    private static final long serialVersionUID = 4783402394156393291L;
    private Map<String, AudioFile> favoriteSongs = new HashMap<String, AudioFile>();
    private Map<String, Album> favoriteAlbums = new HashMap<String, Album>();
    private Map<String, Artist> favoriteArtists = new HashMap<String, Artist>();
    private transient boolean dirty;

    public List<AudioFile> getAllFavoriteSongs() {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Artist comparable : this.favoriteArtists.values()) {
            arrayList.addAll(comparable.getAudioFiles());
        }
        for (Album album : this.favoriteAlbums.values()) {
            arrayList.addAll(album.getAudioFiles());
        }
        arrayList.addAll(this.favoriteSongs.values());
        return arrayList;
    }

    public Map<String, AudioFile> getAllFavoriteSongsMap() {
        HashMap<String, AudioFile> hashMap = new HashMap<String, AudioFile>();
        for (AudioFile audioFile : this.getAllFavoriteSongs()) {
            hashMap.put(audioFile.getUrl(), audioFile);
        }
        return hashMap;
    }

    public Map<String, Album> getFavoriteAlbums() {
        return this.favoriteAlbums;
    }

    public Map<String, Artist> getFavoriteArtists() {
        return this.favoriteArtists;
    }

    public Map<String, AudioFile> getFavoriteAudioFiles() {
        return this.favoriteSongs;
    }

    public void setFavoriteAlbums(Map<String, Album> map) {
        this.favoriteAlbums = map;
    }

    public void setFavoriteArtists(Map<String, Artist> map) {
        this.favoriteArtists = map;
    }

    public void setFavoriteSongs(Map<String, AudioFile> map) {
        this.favoriteSongs = map;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean bl) {
        this.dirty = bl;
    }
}

