/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.AbstractChangeTagProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.utils.ImageUtils;

public class SetCoversProcess
extends AbstractChangeTagProcess {
    private Map<AudioFile, Image> filesAndCovers;

    SetCoversProcess(List<AudioFile> list) {
        super(list);
    }

    @Override
    protected void retrieveInformationBeforeChangeTags() {
        super.retrieveInformationBeforeChangeTags();
        this.filesAndCovers = this.getCoversForFiles(this.getFilesToChange());
    }

    @Override
    protected void changeTag(AudioFile audioFile) throws IOException {
        BufferedImage bufferedImage = ImageUtils.toBufferedImage(this.filesAndCovers.get(audioFile));
        AbstractTag abstractTag = AudioFile.getNewTag(audioFile, new EditTagInfo());
        abstractTag.setInternalImage(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        TagModifier.setInfo(audioFile, abstractTag, true, byteArrayOutputStream.toByteArray());
    }

    private Map<AudioFile, Image> getCoversForFiles(List<AudioFile> list) {
        HashMap<AudioFile, Image> hashMap = new HashMap<AudioFile, Image>();
        HashMap<Integer, Image> hashMap2 = new HashMap<Integer, Image>();
        for (AudioFile audioFile : list) {
            if (Artist.isUnknownArtist(audioFile.getArtist()) || Album.isUnknownAlbum(audioFile.getAlbum())) continue;
            Image image = null;
            int n = audioFile.getArtist().hashCode() + audioFile.getAlbum().hashCode();
            if (hashMap2.containsKey(n)) {
                image = (Image)hashMap2.get(n);
            } else {
                AlbumInfo albumInfo = LastFmService.getInstance().getAlbum(audioFile.getArtist(), audioFile.getAlbum());
                if (albumInfo == null || (image = LastFmService.getInstance().getImage(albumInfo)) == null) continue;
                hashMap2.put(n, image);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (image == null) continue;
            hashMap.put(audioFile, image);
        }
        return hashMap;
    }
}

