/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Format;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.ImageInfo;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public final class TagModifier {
    private static Logger logger;

    private TagModifier() {
    }

    static void deleteTags(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile) {
        audioFile.setWritable();
        try {
            AudioFileIO.delete((AudioFile)AudioFileIO.read((File)audioFile.getFile()));
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    static void refreshAfterTagModify(List<net.sourceforge.atunes.kernel.modules.repository.data.AudioFile> list) {
        SwingUtilities.invokeLater(new RefreshTagAfterModifyRunnable(list));
    }

    static void setAlbum(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, String string) {
        audioFile.setWritable();
        try {
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.ALBUM, string);
            audioFile2.commit();
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    static void setGenre(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, String string) {
        audioFile.setWritable();
        try {
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            tag.setField(tag.createField(FieldKey.GENRE, string));
            audioFile2.commit();
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    public static void setInfo(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, AbstractTag abstractTag) {
        TagModifier.setInfo(audioFile, abstractTag, false, null);
    }

    static void setInfo(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, AbstractTag abstractTag, boolean bl, byte[] byArray) {
        audioFile.setWritable();
        String string = abstractTag.getTitle();
        String string2 = abstractTag.getAlbum();
        String string3 = abstractTag.getArtist();
        int n = abstractTag.getYear();
        String string4 = abstractTag.getComment();
        String string5 = abstractTag.getGenre();
        String string6 = abstractTag.getLyrics();
        String string7 = abstractTag.getComposer();
        int n2 = abstractTag.getTrackNumber();
        int n3 = abstractTag.getDiscNumber();
        String string8 = abstractTag.getAlbumArtist();
        try {
            Object object;
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            if (net.sourceforge.atunes.kernel.modules.repository.data.AudioFile.isValidAudioFile(audioFile.getFile(), Format.MP3) && (object = (MP3File)audioFile2).hasID3v1Tag() && !object.hasID3v2Tag()) {
                TagModifier.deleteTags(audioFile);
                audioFile2 = AudioFileIO.read((File)audioFile.getFile());
                tag = audioFile2.getTagOrCreateAndSetDefault();
            }
            if (bl) {
                try {
                    tag.deleteArtworkField();
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    TagModifier.getLogger().error("IMAGE       ", StringUtils.getString(new Object[]{"Could not delte artwork field. File: ", audioFile.getUrl(), " Error: ", keyNotFoundException}));
                }
                if (byArray != null) {
                    object = new Artwork();
                    object.setBinaryData(byArray);
                    object.setDescription("cover");
                    object.setPictureType(PictureTypes.DEFAULT_ID.intValue());
                    object.setLinked(false);
                    ImageInfo imageInfo = new ImageInfo();
                    imageInfo.setInput(new ByteArrayInputStream(byArray));
                    object.setMimeType(imageInfo.getMimeType());
                    tag.setField(tag.createField((Artwork)object));
                }
            }
            if (net.sourceforge.atunes.kernel.modules.repository.data.AudioFile.isValidAudioFile(audioFile.getFile(), Format.MP4_1, Format.MP4_2)) {
                tag.deleteField(FieldKey.GENRE);
            }
            TagModifier.setStringTagField(audioFile, tag, FieldKey.ALBUM, string2);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.ARTIST, string3);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.COMMENT, string4);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.GENRE, string5);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.TITLE, string);
            TagModifier.setNumberTagField(audioFile, tag, FieldKey.YEAR, n);
            TagModifier.setNumberTagField(audioFile, tag, FieldKey.TRACK, n2);
            if (n3 <= 0) {
                tag.deleteField(FieldKey.DISC_NO);
            } else {
                object = tag.getFirst(FieldKey.DISC_NO);
                if (!StringUtils.isEmpty((String)object)) {
                    tag.deleteField(FieldKey.DISC_NO);
                    tag.setField(FieldKey.DISC_NO, Integer.toString(n3));
                }
            }
            TagModifier.setStringTagField(audioFile, tag, FieldKey.LYRICS, string6);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.ALBUM_ARTIST, string8);
            TagModifier.setStringTagField(audioFile, tag, FieldKey.COMPOSER, string7);
            audioFile2.setTag(tag);
            audioFile2.commit();
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    private static void setStringTagField(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, Tag tag, FieldKey fieldKey, String string) {
        if (string == null || string.isEmpty()) {
            tag.deleteField(fieldKey);
        } else {
            try {
                tag.setField(tag.createField(fieldKey, string));
            }
            catch (FieldDataInvalidException fieldDataInvalidException) {
                TagModifier.reportWriteFieldError(audioFile, fieldKey, string, (Exception)((Object)fieldDataInvalidException));
            }
            catch (KeyNotFoundException keyNotFoundException) {
                TagModifier.reportWriteFieldError(audioFile, fieldKey, string, (Exception)((Object)keyNotFoundException));
            }
        }
    }

    private static void setNumberTagField(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, Tag tag, FieldKey fieldKey, int n) {
        if (n == -1) {
            tag.deleteField(fieldKey);
        } else {
            try {
                tag.setField(fieldKey, String.valueOf(n));
            }
            catch (KeyNotFoundException keyNotFoundException) {
                TagModifier.reportWriteFieldError(audioFile, fieldKey, Integer.toString(n), (Exception)((Object)keyNotFoundException));
            }
            catch (FieldDataInvalidException fieldDataInvalidException) {
                TagModifier.reportWriteFieldError(audioFile, fieldKey, Integer.toString(n), (Exception)((Object)fieldDataInvalidException));
            }
        }
    }

    static void setLyrics(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, String string) {
        audioFile.setWritable();
        try {
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            tag.setField(tag.createField(FieldKey.LYRICS, string));
            audioFile2.commit();
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    static void setTitles(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, String string) {
        audioFile.setWritable();
        try {
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.TITLE, string);
            audioFile2.commit();
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    static void setTrackNumber(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, Integer n) {
        audioFile.setWritable();
        try {
            AudioFile audioFile2 = AudioFileIO.read((File)audioFile.getFile());
            Tag tag = audioFile2.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.TRACK, n.toString());
            audioFile2.commit();
        }
        catch (IOException iOException) {
            TagModifier.reportWriteError(audioFile, iOException);
        }
        catch (CannotReadException cannotReadException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotReadException));
        }
        catch (TagException tagException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)tagException));
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)readOnlyFileException));
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)invalidAudioFrameException));
        }
        catch (CannotWriteException cannotWriteException) {
            TagModifier.reportWriteError(audioFile, (Exception)((Object)cannotWriteException));
        }
        catch (Exception exception) {
            TagModifier.reportWriteError(audioFile, exception);
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    private static final void reportWriteError(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, Exception exception) {
        TagModifier.getLogger().error("FILE WRITE  ", StringUtils.getString("Could not edit tag. File: ", audioFile.getUrl(), " Error: ", exception));
        TagModifier.getLogger().error("FILE WRITE  ", exception);
    }

    private static final void reportWriteFieldError(net.sourceforge.atunes.kernel.modules.repository.data.AudioFile audioFile, FieldKey fieldKey, String string, Exception exception) {
        TagModifier.getLogger().error("FILE WRITE  ", StringUtils.getString("Could not edit tag field ", fieldKey.name(), " with value \"", string, "\" for file: ", audioFile.getUrl(), " Error: ", exception));
    }

    private static final class RefreshTagAfterModifyRunnable
    implements Runnable {
        private final List<net.sourceforge.atunes.kernel.modules.repository.data.AudioFile> audioFilesEditing;

        private RefreshTagAfterModifyRunnable(List<net.sourceforge.atunes.kernel.modules.repository.data.AudioFile> list) {
            this.audioFilesEditing = list;
        }

        @Override
        public void run() {
            boolean bl = false;
            for (int i = 0; i < this.audioFilesEditing.size(); ++i) {
                if (PlayListHandler.getInstance().getCurrentPlayList(true).contains(this.audioFilesEditing.get(i))) {
                    bl = true;
                }
                if (PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList() == null || !PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList().equals(this.audioFilesEditing.get(i))) continue;
                PlayListHandler.getInstance().selectedAudioObjectHasChanged(this.audioFilesEditing.get(i));
                if (!PlayerHandler.getInstance().isEnginePlaying()) continue;
                GuiHandler.getInstance().updateTitleBar(this.audioFilesEditing.get(i));
            }
            if (bl) {
                ControllerProxy.getInstance().getPlayListController().refreshPlayList();
            }
            ControllerProxy.getInstance().getNavigationController().notifyReload();
        }
    }
}

