/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.state.beans;

import java.awt.Font;
import java.beans.ConstructorProperties;

public final class FontBean {
    private String name;
    private int style;
    private int size;

    @ConstructorProperties(value={"name", "style", "size"})
    public FontBean(String string, int n, int n2) {
        this.name = string;
        this.style = n;
        this.size = n2;
    }

    public FontBean(Font font) {
        this.name = font.getName();
        this.style = font.getStyle();
        this.size = font.getSize();
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public Font toFont() {
        return new Font(this.name, this.style, this.size);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.size;
        n = 31 * n + this.style;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FontBean fontBean = (FontBean)object;
        if (this.name == null ? fontBean.name != null : !this.name.equals(fontBean.name)) {
            return false;
        }
        if (this.size != fontBean.size) {
            return false;
        }
        return this.style == fontBean.style;
    }
}

