/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.state.beans;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.Proxy;
import java.util.Arrays;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;

public final class ProxyBean {
    public static final String HTTP_PROXY = "HTTP_PROXY";
    public static final String SOCKS_PROXY = "SOCKS_PROXY";
    private String type;
    private String url;
    private int port;
    private String user;
    private String password;
    private byte[] encryptedPassword;

    public ProxyBean() {
    }

    @ConstructorProperties(value={"type", "url", "port", "user", "encryptedPassword"})
    public ProxyBean(String string, String string2, int n, String string3, byte[] byArray) {
        this.type = string;
        this.url = string2;
        this.port = n;
        this.encryptedPassword = byArray != null ? Arrays.copyOf(byArray, byArray.length) : null;
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword != null ? Arrays.copyOf(this.encryptedPassword, this.encryptedPassword.length) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setEncryptedPassword(byte[] byArray) {
        this.encryptedPassword = Arrays.copyOf(byArray, byArray.length);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public static Proxy getProxy(ProxyBean proxyBean) throws IOException {
        if (proxyBean == null) {
            return null;
        }
        return new Proxy(proxyBean.getType().equals(HTTP_PROXY) ? Proxy.Type.HTTP : Proxy.Type.SOCKS, proxyBean.getUrl(), proxyBean.getPort(), proxyBean.getUser(), proxyBean.getPassword());
    }
}

