/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm;

import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class GetCoversProcess
extends AbstractProcess {
    private Artist artist;

    public GetCoversProcess(Artist artist, Component component) {
        this.artist = artist;
        this.setOwner(component);
    }

    @Override
    protected long getProcessSize() {
        return this.artist.getAlbums().size();
    }

    @Override
    protected boolean runProcess() {
        long l = 0L;
        ArrayList<Album> arrayList = new ArrayList<Album>(this.artist.getAlbums().values());
        for (int i = 0; i < arrayList.size() && !this.isCanceled(); ++i) {
            Image image;
            Album album = (Album)arrayList.get(i);
            if (!album.hasCoverDownloaded() && (image = LastFmService.getInstance().getAlbumImage(this.artist.getName(), album.getName())) != null) {
                try {
                    ImageUtils.writeImageToFile(image, AudioFilePictureUtils.getFileNameForCover(album.getAudioFiles().get(0)));
                }
                catch (IOException iOException) {
                    new Logger().error("CONTEXT     ", StringUtils.getString("Error writing image for artist: ", this.artist.getName(), " album: ", album.getName(), " Error: ", iOException.getMessage()));
                }
            }
            this.setCurrentProgress(++l);
        }
        return true;
    }

    @Override
    public String getProgressDialogTitle() {
        return I18nUtils.getString("RETRIEVING_COVERS");
    }

    @Override
    protected void runCancel() {
    }
}

