/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm;

import java.awt.Image;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Authenticator;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Playlist;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.lastfm.scrobble.ResponseStatus;
import net.roarsoftware.lastfm.scrobble.Scrobbler;
import net.roarsoftware.lastfm.scrobble.Source;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.AlbumListInfo;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.kernel.modules.context.SimilarArtistsInfo;
import net.sourceforge.atunes.kernel.modules.context.TrackInfo;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmCache;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmLovedTracks;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.ScrobblerException;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.SubmissionData;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmAlbum;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmAlbumList;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmLovedTrack;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmSimilarArtists;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.CryptoUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class LastFmService {
    private static final byte[] API_KEY = new byte[]{78, 119, -39, -5, -89, -107, -38, 41, -87, -107, 122, 98, -33, 46, 32, -47, -44, 54, 97, 67, 105, 122, 11, -26, -81, 90, 94, 55, 121, 11, 14, -104, -70, 123, -88, -70, -108, 75, -77, 98};
    private static final byte[] API_SECRET = new byte[]{38, -8, 33, 63, 10, 86, 29, -2, 87, -63, 67, 111, -5, -101, -87, 38, 2, 35, 86, -86, 19, 110, -81, -115, 102, 54, -24, 27, 40, -124, -57, -62, -70, 123, -88, -70, -108, 75, -77, 98};
    private static final String CLIENT_ID = "atu";
    private static final String CLIENT_VERSION = Constants.VERSION.toShortString();
    private static final String ARTIST_WILDCARD = "(%ARTIST%)";
    private static final String LANGUAGE_PARAM = "?setlang=";
    private static final String LANGUAGE_WILDCARD = "(%LANGUAGE%)";
    private static final String ARTIST_WIKI_URL = StringUtils.getString("http://www.lastfm.com/music/", "(%ARTIST%)", "/+wiki", "?setlang=", "(%LANGUAGE%)");
    private static final String VARIOUS_ARTISTS = "Various Artists";
    private static final int MIN_DURATION_TO_SUBMIT = 30;
    private static final int MAX_SUBMISSIONS = 50;
    private static Logger logger;
    private Proxy proxy;
    private Scrobbler scrobbler;
    private String user;
    private String password;
    private boolean handshakePerformed;
    private static LastFmCache lastFmCache;
    private ExecutorService scrobblerExecutorService = Executors.newSingleThreadExecutor();
    private static LastFmService instance;

    public static LastFmService getInstance() {
        if (instance == null) {
            instance = new LastFmService(ApplicationState.getInstance().getProxy(), ApplicationState.getInstance().getLastFmUser(), ApplicationState.getInstance().getLastFmPassword());
        }
        return instance;
    }

    private LastFmService(ProxyBean proxyBean, String string, String string2) {
        Proxy proxy = null;
        try {
            if (proxyBean != null) {
                proxy = Proxy.getProxy(proxyBean);
            }
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
        }
        this.proxy = proxy;
        this.user = string;
        this.password = string2;
        Caller.getInstance().setCache(null);
        Caller.getInstance().setProxy((java.net.Proxy)proxy);
        Caller.getInstance().setUserAgent(CLIENT_ID);
        this.scrobbler = Scrobbler.newScrobbler((String)CLIENT_ID, (String)NetworkUtils.encodeString(CLIENT_VERSION), (String)string);
        this.handshakePerformed = false;
    }

    public void updateService() {
        instance = null;
    }

    public void finishService() {
        this.scrobblerExecutorService.shutdownNow();
        lastFmCache.shutdown();
    }

    public AlbumInfo getAlbum(String string, String string2) {
        try {
            Album album;
            AlbumInfo albumInfo = lastFmCache.retrieveAlbumInfo(string, string2);
            if (albumInfo == null && (album = Album.getInfo((String)string, (String)string2, (String)LastFmService.getApiKey())) != null) {
                Playlist playlist = Playlist.fetchAlbumPlaylist((String)album.getId(), (String)LastFmService.getApiKey());
                albumInfo = LastFmAlbum.getAlbum(album, playlist);
                lastFmCache.storeAlbumInfo(string, string2, albumInfo);
            }
            return albumInfo;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public Image getAlbumImage(String string, String string2) {
        Image image = null;
        AlbumInfo albumInfo = this.getAlbum(string, string2);
        if (albumInfo != null) {
            image = this.getImage(albumInfo);
        }
        return image;
    }

    public AlbumListInfo getAlbumList(String string, boolean bl, int n) {
        try {
            ArrayList<AlbumInfo> arrayList;
            AlbumListInfo albumListInfo = lastFmCache.retrieveAbumList(string);
            if (albumListInfo == null && (arrayList = Artist.getTopAlbums((String)string, (String)LastFmService.getApiKey())) != null) {
                Iterator<AlbumInfo> iterator = LastFmAlbumList.getAlbumList((Collection<Album>)arrayList, string);
                ArrayList<AlbumInfo> serializable = new ArrayList<AlbumInfo>();
                for (AlbumInfo albumInfo : iterator.getAlbums()) {
                    if (albumInfo.getBigCoverURL() == null || albumInfo.getBigCoverURL().isEmpty()) continue;
                    serializable.add(albumInfo);
                }
                albumListInfo = new LastFmAlbumList();
                albumListInfo.setArtist(string);
                albumListInfo.setAlbums(serializable);
                lastFmCache.storeAlbumList(string, albumListInfo);
            }
            if (albumListInfo != null) {
                arrayList = null;
                if (bl) {
                    arrayList = new ArrayList<AlbumInfo>();
                    for (AlbumInfo albumInfo : albumListInfo.getAlbums()) {
                        if (albumInfo.getArtist().equals(VARIOUS_ARTISTS)) continue;
                        arrayList.add(albumInfo);
                    }
                    albumListInfo.setAlbums(arrayList);
                }
                if (n > 0) {
                    arrayList = new ArrayList();
                    for (AlbumInfo albumInfo : albumListInfo.getAlbums()) {
                        AlbumInfo albumInfo2 = this.getAlbum(string, albumInfo.getTitle());
                        if (albumInfo2 == null || albumInfo2.getTracks() == null || albumInfo2.getTracks().size() < n) continue;
                        arrayList.add(albumInfo);
                    }
                }
                if (arrayList != null) {
                    albumListInfo.setAlbums(arrayList);
                }
            }
            return albumListInfo;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public String getArtistTopTag(String string) {
        try {
            Collection collection = Artist.getTopTags((String)string, (String)LastFmService.getApiKey());
            ArrayList arrayList = new ArrayList(collection);
            return arrayList.isEmpty() ? "" : (String)arrayList.get(0);
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public Image getImage(AlbumInfo albumInfo) {
        try {
            Image image = null;
            image = lastFmCache.retrieveAlbumCover(albumInfo);
            if (image == null && albumInfo.getBigCoverURL() != null && !albumInfo.getBigCoverURL().isEmpty()) {
                image = NetworkUtils.getImage(NetworkUtils.getConnection(albumInfo.getBigCoverURL(), this.proxy));
                lastFmCache.storeAlbumCover(albumInfo, new ImageIcon(image));
            }
            return image;
        }
        catch (IOException iOException) {
            LastFmService.getLogger().error("SERVICE     ", iOException.getMessage());
            LastFmService.getLogger().debug("SERVICE     ", iOException);
            return null;
        }
    }

    public Image getImage(ArtistInfo artistInfo) {
        try {
            Image image = lastFmCache.retrieveArtistThumbImage(artistInfo);
            if (image == null && artistInfo.getImageUrl() != null && !artistInfo.getImageUrl().isEmpty()) {
                image = this.getArtistImageFromLastFM(artistInfo.getName(), ImageSize.LARGE);
                if (image == null) {
                    image = NetworkUtils.getImage(NetworkUtils.getConnection(artistInfo.getImageUrl(), this.proxy));
                }
                lastFmCache.storeArtistThumbImage(artistInfo, new ImageIcon(image));
            }
            return image;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public Image getImage(String string) {
        try {
            String string2;
            Image image = lastFmCache.retrieveArtistImage(string);
            if (image != null) {
                return image;
            }
            image = this.getArtistImageFromLastFM(string, ImageSize.ORIGINAL);
            if (image == null && !(string2 = this.getSimilarArtists(string).getPicture()).trim().isEmpty()) {
                image = NetworkUtils.getImage(NetworkUtils.getConnection(string2, this.proxy));
            }
            if (image != null) {
                lastFmCache.storeArtistImage(string, new ImageIcon(image));
            }
            return image;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    private Image getArtistImageFromLastFM(String string, ImageSize imageSize) {
        try {
            Set set;
            PaginatedResult paginatedResult = Artist.getImages((String)string, (int)1, (int)1, (String)LastFmService.getApiKey());
            ArrayList arrayList = new ArrayList(paginatedResult.getPageResults());
            if (!arrayList.isEmpty() && (set = ((net.roarsoftware.lastfm.Image)arrayList.get(0)).availableSizes()).contains(imageSize)) {
                return NetworkUtils.getImage(NetworkUtils.getConnection(((net.roarsoftware.lastfm.Image)arrayList.get(0)).getImageURL(imageSize), this.proxy));
            }
        }
        catch (IOException iOException) {
            LastFmService.getLogger().error("SERVICE     ", iOException);
        }
        return null;
    }

    public SimilarArtistsInfo getSimilarArtists(String string) {
        try {
            SimilarArtistsInfo similarArtistsInfo = lastFmCache.retrieveArtistSimilar(string);
            if (similarArtistsInfo != null) {
                float f = 0.0f;
                for (ArtistInfo artistInfo : similarArtistsInfo.getArtists()) {
                    float f2 = 0.0f;
                    try {
                        f2 = Float.parseFloat(artistInfo.getMatch());
                        if (!(f2 > f)) continue;
                        f = f2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        similarArtistsInfo = null;
                    }
                }
                if (f <= 1.0f) {
                    similarArtistsInfo = null;
                }
            }
            if (similarArtistsInfo == null) {
                Collection collection = Artist.getSimilar((String)string, (String)LastFmService.getApiKey());
                Artist artist = Artist.getInfo((String)string, (String)LastFmService.getApiKey());
                if (artist != null) {
                    similarArtistsInfo = LastFmSimilarArtists.getSimilarArtists(collection, artist);
                    lastFmCache.storeArtistSimilar(string, similarArtistsInfo);
                }
            }
            return similarArtistsInfo;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public String getWikiText(String string) {
        try {
            String string2 = lastFmCache.retrieveArtistWiki(string);
            if (string2 == null) {
                Artist artist = Artist.getInfo((String)string, (Locale)ApplicationState.getInstance().getLocale().getLocale(), (String)LastFmService.getApiKey());
                string2 = artist != null ? artist.getWikiSummary() : "";
                string2 = string2.replaceAll("<.*?>", "");
                string2 = StringUtils.unescapeHTML(string2, 0);
                lastFmCache.storeArtistWiki(string, string2);
            }
            return string2;
        }
        catch (Exception exception) {
            LastFmService.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public String getWikiURL(String string) {
        return ARTIST_WIKI_URL.replace(ARTIST_WILDCARD, NetworkUtils.encodeString(string)).replace(LANGUAGE_WILDCARD, ApplicationState.getInstance().getLocale().getLocale().getLanguage());
    }

    private void submit(AudioFile audioFile, long l) throws ScrobblerException {
        if (!(this.checkUser() && this.checkPassword() && this.checkArtist(audioFile) && this.checkTitle(audioFile) && this.checkDuration(audioFile))) {
            return;
        }
        long l2 = System.currentTimeMillis() / 1000L - l;
        LastFmService.getLogger().info("SERVICE     ", "Trying to submit song to Last.fm");
        try {
            this.performHandshakeIfNeeded();
            net.roarsoftware.lastfm.scrobble.SubmissionData submissionData = new net.roarsoftware.lastfm.scrobble.SubmissionData(audioFile.getArtist(), audioFile.getTitle(), audioFile.getAlbum(), audioFile.getDuration(), audioFile.getTrackNumber(), Source.USER, null, l2);
            ResponseStatus responseStatus = this.scrobbler.submit(submissionData);
            if (!responseStatus.ok()) {
                this.handshakePerformed = false;
                lastFmCache.addSubmissionData(new SubmissionData(audioFile.getArtist(), audioFile.getTitle(), audioFile.getAlbum(), audioFile.getDuration(), audioFile.getTrackNumber(), Source.USER.toString(), (int)l2));
                throw new ScrobblerException(responseStatus.getStatus());
            }
            LastFmService.getLogger().info("SERVICE     ", "Song submitted to Last.fm");
        }
        catch (IOException iOException) {
            LastFmService.getLogger().error("SERVICE     ", iOException);
            this.handshakePerformed = false;
            lastFmCache.addSubmissionData(new SubmissionData(audioFile.getArtist(), audioFile.getTitle(), audioFile.getAlbum(), audioFile.getDuration(), audioFile.getTrackNumber(), Source.USER.toString(), (int)l2));
            throw new ScrobblerException(iOException.getMessage());
        }
    }

    public void addLovedSong(AudioObject audioObject) {
        if (!(this.checkUser() && this.checkAudioFile(audioObject) && this.checkPassword() && this.checkArtist(audioObject))) {
            return;
        }
        LastFmService.getLogger().info("SERVICE     ", StringUtils.getString("Trying to submit loved song to Last.fm: ", audioObject.getArtist(), " - ", audioObject.getTitle()));
        Result result = Track.love((String)audioObject.getArtist(), (String)audioObject.getTitle(), (Session)this.getSession());
        if (result.getStatus().equals((Object)Result.Status.OK)) {
            LastFmService.getLogger().info("SERVICE     ", StringUtils.getString("Loved song submitted OK"));
        } else {
            LastFmService.getLogger().error("SERVICE     ", StringUtils.getString("Error while submitting loved song"));
        }
    }

    public void addBannedSong(AudioObject audioObject) {
        if (!(this.checkUser() && this.checkAudioFile(audioObject) && this.checkPassword() && this.checkArtist(audioObject))) {
            return;
        }
        LastFmService.getLogger().info("SERVICE     ", StringUtils.getString("Trying to submit banned song to Last.fm: ", audioObject.getArtist(), " - ", audioObject.getTitle()));
        Result result = Track.ban((String)audioObject.getArtist(), (String)audioObject.getTitle(), (Session)this.getSession());
        if (result.getStatus().equals((Object)Result.Status.OK)) {
            LastFmService.getLogger().info("SERVICE     ", StringUtils.getString("Banned song submitted OK"));
        } else {
            LastFmService.getLogger().error("SERVICE     ", StringUtils.getString("Error while submitting banned song"));
        }
    }

    private void submitCache() throws ScrobblerException {
        if (!this.checkUser() || !this.checkPassword()) {
            return;
        }
        List<SubmissionData> list = lastFmCache.getSubmissionData();
        if (!list.isEmpty()) {
            int n = list.size();
            if (n > 50) {
                list = list.subList(n - 50, n);
            }
            LastFmService.getLogger().info("SERVICE     ", "Trying to submit cache to Last.fm");
            try {
                this.performHandshakeIfNeeded();
                ArrayList<net.roarsoftware.lastfm.scrobble.SubmissionData> arrayList = new ArrayList<net.roarsoftware.lastfm.scrobble.SubmissionData>();
                for (SubmissionData submissionData : list) {
                    net.roarsoftware.lastfm.scrobble.SubmissionData submissionData2 = new net.roarsoftware.lastfm.scrobble.SubmissionData(submissionData.getArtist(), submissionData.getTitle(), submissionData.getAlbum(), submissionData.getDuration(), submissionData.getTrackNumber(), Source.valueOf((String)submissionData.getSource()), null, (long)submissionData.getStartTime());
                    arrayList.add(submissionData2);
                }
                ResponseStatus responseStatus = this.scrobbler.submit(arrayList);
                if (!responseStatus.ok()) {
                    this.handshakePerformed = false;
                    throw new ScrobblerException(responseStatus.getStatus());
                }
                lastFmCache.removeSubmissionData();
                LastFmService.getLogger().info("SERVICE     ", "Cache submitted to Last.fm");
            }
            catch (IOException iOException) {
                LastFmService.getLogger().error("SERVICE     ", iOException);
                this.handshakePerformed = false;
                throw new ScrobblerException(iOException.getMessage());
            }
        }
    }

    private void submitNowPlayingInfo(AudioFile audioFile) throws ScrobblerException {
        if (!(this.checkUser() && this.checkPassword() && this.checkArtist(audioFile) && this.checkTitle(audioFile))) {
            return;
        }
        LastFmService.getLogger().info("SERVICE     ", "Trying to submit now playing info to Last.fm");
        try {
            this.performHandshakeIfNeeded();
            ResponseStatus responseStatus = this.scrobbler.nowPlaying(audioFile.getArtist(), audioFile.getTitle(), audioFile.getAlbum(), audioFile.getDuration(), audioFile.getTrackNumber());
            if (!responseStatus.ok()) {
                this.handshakePerformed = false;
                throw new ScrobblerException(responseStatus.getStatus());
            }
            LastFmService.getLogger().info("SERVICE     ", "Now playing info submitted to Last.fm");
        }
        catch (IOException iOException) {
            LastFmService.getLogger().error("SERVICE     ", iOException);
            this.handshakePerformed = false;
            throw new ScrobblerException(iOException.getMessage());
        }
    }

    private void performHandshakeIfNeeded() throws IOException, ScrobblerException {
        if (!this.handshakePerformed) {
            ResponseStatus responseStatus = this.scrobbler.handshake(this.password);
            if (!responseStatus.ok()) {
                throw new ScrobblerException(responseStatus.getStatus());
            }
            this.handshakePerformed = true;
        }
    }

    public List<LastFmLovedTrack> getLovedTracks() {
        if (this.user != null) {
            try {
                return LastFmLovedTracks.getLovedTracks(this.user, null, this.proxy);
            }
            catch (Exception exception) {
                LastFmService.getLogger().error("SERVICE     ", exception);
            }
        }
        return Collections.emptyList();
    }

    private boolean checkUser() {
        if (this.user == null || this.user.equals("")) {
            LastFmService.getLogger().debug("SERVICE     ", "Don't submit to Last.fm: Empty user");
            return false;
        }
        return true;
    }

    private boolean checkAudioFile(AudioObject audioObject) {
        return audioObject instanceof AudioFile;
    }

    private boolean checkPassword() {
        if (this.password == null || this.password.equals("")) {
            LastFmService.getLogger().debug("SERVICE     ", "Don't submit to Last.fm: Empty password");
            return false;
        }
        return true;
    }

    private boolean checkArtist(AudioObject audioObject) {
        if (net.sourceforge.atunes.kernel.modules.repository.data.Artist.isUnknownArtist(audioObject.getArtist())) {
            LastFmService.getLogger().debug("SERVICE     ", "Don't submit to Last.fm: Unknown artist");
            return false;
        }
        return true;
    }

    private boolean checkTitle(AudioObject audioObject) {
        if (audioObject.getTitle().trim().equals("")) {
            LastFmService.getLogger().debug("SERVICE     ", "Don't submit to Last.fm: Unknown Title");
            return false;
        }
        return true;
    }

    private boolean checkDuration(AudioObject audioObject) {
        if (audioObject.getDuration() < 30) {
            LastFmService.getLogger().debug("SERVICE     ", "Don't submit to Last.fm: Lenght < ", 30);
            return false;
        }
        return true;
    }

    public boolean clearCache() {
        return lastFmCache.clearCache();
    }

    public String getTitleForFile(AudioFile audioFile) {
        AlbumInfo albumInfo;
        if (!net.sourceforge.atunes.kernel.modules.repository.data.Artist.isUnknownArtist(audioFile.getArtist()) && !net.sourceforge.atunes.kernel.modules.repository.data.Album.isUnknownAlbum(audioFile.getAlbum()) && audioFile.getTrackNumber() > 0 && (albumInfo = this.getAlbum(audioFile.getArtist(), audioFile.getAlbum())) != null && albumInfo.getTracks().size() >= audioFile.getTrackNumber()) {
            return albumInfo.getTracks().get(audioFile.getTrackNumber() - 1).getTitle();
        }
        return null;
    }

    public int getTrackNumberForFile(AudioFile audioFile) {
        AlbumInfo albumInfo;
        if (!(net.sourceforge.atunes.kernel.modules.repository.data.Artist.isUnknownArtist(audioFile.getArtist()) || net.sourceforge.atunes.kernel.modules.repository.data.Album.isUnknownAlbum(audioFile.getAlbum()) || StringUtils.isEmpty(audioFile.getTitle()) || (albumInfo = this.getAlbum(audioFile.getArtist(), audioFile.getAlbum())) == null)) {
            int n = 1;
            for (TrackInfo trackInfo : albumInfo.getTracks()) {
                if (trackInfo.getTitle().equalsIgnoreCase(audioFile.getTitle())) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public void submitToLastFm(AudioFile audioFile, long l) {
        if (ApplicationState.getInstance().isLastFmEnabled()) {
            SubmitToLastFmRunnable submitToLastFmRunnable = new SubmitToLastFmRunnable(l, audioFile);
            try {
                this.scrobblerExecutorService.submit(submitToLastFmRunnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LastFmService.getLogger().info("SERVICE     ", "execution of submission runnable rejected");
            }
        }
    }

    public void submitCacheToLastFm() {
        if (ApplicationState.getInstance().isLastFmEnabled()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        LastFmService.this.submitCache();
                    }
                    catch (ScrobblerException scrobblerException) {
                        if (scrobblerException.getStatus() == 2) {
                            LastFmService.getLogger().error("SERVICE     ", "Authentication failure on Last.fm service");
                        }
                        LastFmService.getLogger().error("SERVICE     ", scrobblerException.getMessage());
                    }
                }
            };
            try {
                this.scrobblerExecutorService.submit(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LastFmService.getLogger().info("SERVICE     ", "execution of cache submission runnable rejected");
            }
        }
    }

    public void submitNowPlayingInfoToLastFm(AudioFile audioFile) {
        if (ApplicationState.getInstance().isLastFmEnabled()) {
            SubmitNowPlayingInfoRunnable submitNowPlayingInfoRunnable = new SubmitNowPlayingInfoRunnable(audioFile);
            try {
                this.scrobblerExecutorService.submit(submitNowPlayingInfoRunnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LastFmService.getLogger().info("SERVICE     ", "execution of now playing runnable rejected");
            }
        }
    }

    public Collection<Event> getArtistEvents(String string) {
        return Artist.getEvents((String)string, (String)LastFmService.getApiKey());
    }

    public boolean testLogin(String string, String string2) {
        return Authenticator.getMobileSession((String)string, (String)string2, (String)LastFmService.getApiKey(), (String)LastFmService.getApiSecret()) != null;
    }

    private static String getApiKey() {
        try {
            return new String(CryptoUtils.decrypt(API_KEY));
        }
        catch (GeneralSecurityException generalSecurityException) {
            LastFmService.getLogger().internalError(generalSecurityException);
        }
        catch (IOException iOException) {
            LastFmService.getLogger().internalError(iOException);
        }
        return "";
    }

    private static String getApiSecret() {
        try {
            return new String(CryptoUtils.decrypt(API_SECRET));
        }
        catch (GeneralSecurityException generalSecurityException) {
            LastFmService.getLogger().internalError(generalSecurityException);
        }
        catch (IOException iOException) {
            LastFmService.getLogger().internalError(iOException);
        }
        return "";
    }

    private Session getSession() {
        return Authenticator.getMobileSession((String)this.user, (String)this.password, (String)LastFmService.getApiKey(), (String)LastFmService.getApiSecret());
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    static {
        lastFmCache = new LastFmCache();
    }

    private final class SubmitToLastFmRunnable
    implements Runnable {
        private final long secondsPlayed;
        private final AudioFile audioFile;

        private SubmitToLastFmRunnable(long l, AudioFile audioFile) {
            this.secondsPlayed = l;
            this.audioFile = audioFile;
        }

        @Override
        public void run() {
            try {
                LastFmService.this.submit(this.audioFile, this.secondsPlayed);
            }
            catch (ScrobblerException scrobblerException) {
                if (scrobblerException.getStatus() == 2) {
                    LastFmService.getLogger().error("SERVICE     ", "Authentication failure on Last.fm service");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("LASTFM_USER_ERROR"));
                            ApplicationState.getInstance().setLastFmEnabled(false);
                        }
                    });
                }
                LastFmService.getLogger().error("SERVICE     ", scrobblerException.getMessage());
            }
        }
    }

    private final class SubmitNowPlayingInfoRunnable
    implements Runnable {
        private final AudioFile audioFile;

        private SubmitNowPlayingInfoRunnable(AudioFile audioFile) {
            this.audioFile = audioFile;
        }

        @Override
        public void run() {
            try {
                LastFmService.this.submitNowPlayingInfo(this.audioFile);
            }
            catch (ScrobblerException scrobblerException) {
                if (scrobblerException.getStatus() == 2) {
                    LastFmService.getLogger().error("SERVICE     ", "Authentication failure on Last.fm service");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("LASTFM_USER_ERROR"));
                            ApplicationState.getInstance().setLastFmEnabled(false);
                        }
                    });
                }
                LastFmService.getLogger().error("SERVICE     ", scrobblerException.getMessage());
            }
        }
    }
}

