/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.lastfm.Playlist;
import net.roarsoftware.lastfm.Track;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.TrackInfo;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmTrack;
import net.sourceforge.atunes.utils.StringUtils;

public class LastFmAlbum
implements AlbumInfo {
    private static final long serialVersionUID = -8021357529697065642L;
    private static final ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("d MMM yyyy, HH:mm", Locale.US);
        }
    };
    private String artist;
    private String title;
    private String url;
    private String releaseDateString;
    private String bigCoverURL;
    private String coverURL;
    private String smallCoverURL;
    private List<TrackInfo> tracks;
    private ImageIcon cover;

    public static AlbumInfo getAlbum(Album album, Playlist playlist) {
        LastFmAlbum lastFmAlbum = new LastFmAlbum();
        lastFmAlbum.artist = album.getArtist();
        lastFmAlbum.title = album.getName();
        lastFmAlbum.url = album.getUrl();
        lastFmAlbum.releaseDateString = album.getReleaseDate() != null ? album.getReleaseDate().toString() : "";
        lastFmAlbum.bigCoverURL = album.getImageURL(ImageSize.LARGE);
        lastFmAlbum.coverURL = album.getImageURL(ImageSize.ORIGINAL);
        lastFmAlbum.smallCoverURL = album.getImageURL(ImageSize.SMALL);
        if (playlist != null) {
            ArrayList<TrackInfo> arrayList = new ArrayList<TrackInfo>();
            for (Object object : playlist.getTracks()) {
                arrayList.add(LastFmTrack.getTrack((Track)object));
            }
            if (!arrayList.isEmpty()) {
                Object object;
                String string = ((TrackInfo)arrayList.get(0)).getTitle();
                object = StringUtils.getTextBetweenChars(string, '(', ')');
                object.addAll(StringUtils.getTextBetweenChars(string, '[', ']'));
                object.addAll(StringUtils.getTextBetweenChars(string, '{', '}'));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String object2 = (String)iterator.next();
                    boolean bl = true;
                    for (int string2 = 1; string2 < arrayList.size() && bl; ++string2) {
                        if (((TrackInfo)arrayList.get(string2)).getTitle().contains(object2)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    arrayList2.add(object2);
                }
                for (TrackInfo trackInfo : arrayList) {
                    for (String string2 : arrayList2) {
                        trackInfo.setTitle(trackInfo.getTitle().replace(string2, ""));
                    }
                    trackInfo.setTitle(trackInfo.getTitle().trim());
                }
            }
            lastFmAlbum.tracks = arrayList;
        }
        return lastFmAlbum;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getArtistUrl() {
        return this.url.substring(0, this.url.lastIndexOf(47));
    }

    @Override
    public String getBigCoverURL() {
        return this.bigCoverURL;
    }

    @Override
    public ImageIcon getCover() {
        return this.cover;
    }

    @Override
    public String getCoverURL() {
        return this.coverURL;
    }

    @Override
    public Date getReleaseDate() {
        try {
            return df.get().parse(this.releaseDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public String getReleaseDateString() {
        return this.releaseDateString;
    }

    @Override
    public String getSmallCoverURL() {
        return this.smallCoverURL;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<TrackInfo> getTracks() {
        return this.tracks;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getYear() {
        Date date = this.getReleaseDate();
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return Integer.toString(calendar.get(1));
    }

    @Override
    public void setArtist(String string) {
        this.artist = string;
    }

    @Override
    public void setBigCoverURL(String string) {
        this.bigCoverURL = string;
    }

    @Override
    public void setCover(ImageIcon imageIcon) {
        this.cover = imageIcon;
    }

    @Override
    public void setCoverURL(String string) {
        this.coverURL = string;
    }

    @Override
    public void setReleaseDateString(String string) {
        this.releaseDateString = string;
    }

    @Override
    public void setSmallCoverURL(String string) {
        this.smallCoverURL = string;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void setTracks(List<? extends TrackInfo> list) {
        this.tracks = list != null ? new ArrayList<TrackInfo>(list) : null;
    }

    @Override
    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public String toString() {
        return StringUtils.getString(this.artist, " - ", this.title);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bigCoverURL == null ? 0 : this.bigCoverURL.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LastFmAlbum lastFmAlbum = (LastFmAlbum)object;
        return !(this.bigCoverURL == null ? lastFmAlbum.bigCoverURL != null : !this.bigCoverURL.equals(lastFmAlbum.bigCoverURL));
    }
}

