/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm.data;

import javax.swing.ImageIcon;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.ImageSize;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;

public class LastFmArtist
implements ArtistInfo {
    private static final long serialVersionUID = 2077813440652134441L;
    private String name;
    private String match;
    private String url;
    private String imageUrl;
    private ImageIcon image;
    private transient boolean available;

    protected static LastFmArtist getArtist(Artist artist) {
        LastFmArtist lastFmArtist = new LastFmArtist();
        lastFmArtist.name = artist.getName();
        lastFmArtist.match = String.valueOf((int)(artist.getSimilarityMatch() * 100.0f));
        String string = artist.getUrl();
        lastFmArtist.url = string.startsWith("http") ? string : "http://" + string;
        lastFmArtist.imageUrl = artist.getImageURL(ImageSize.LARGE);
        return lastFmArtist;
    }

    @Override
    public ImageIcon getImage() {
        return this.image;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public String getMatch() {
        return this.match;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
    }

    @Override
    public void setImageUrl(String string) {
        this.imageUrl = string;
    }

    @Override
    public void setMatch(String string) {
        this.match = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean bl) {
        this.available = bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LastFmArtist lastFmArtist = (LastFmArtist)object;
        return !(this.name == null ? lastFmArtist.name != null : !this.name.equals(lastFmArtist.name));
    }
}

