/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.misc.AbstractCache;
import net.sourceforge.atunes.misc.log.Logger;

public class LyricsCache
extends AbstractCache {
    private static final String LYRICS = "lyrics";
    private Logger logger;

    public LyricsCache() {
        super(LyricsCache.class.getResource("/settings/ehcache-lyrics.xml"));
    }

    public synchronized boolean clearCache() {
        try {
            this.getCache().removeAll();
            this.getCache().flush();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from lyrics cache");
            return true;
        }
        return false;
    }

    public synchronized Lyrics retrieveLyric(String string, String string2) {
        Element element = this.getCache().get((Serializable)((Object)LyricsCache.id(string, string2)));
        if (element != null) {
            return (Lyrics)element.getValue();
        }
        return null;
    }

    public synchronized void storeLyric(String string, String string2, Lyrics lyrics) {
        if (string == null || string2 == null || lyrics == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)LyricsCache.id(string, string2)), (Serializable)lyrics);
        this.getCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored lyric for ", string2);
    }

    private static String id(String string, String string2) {
        return string + string2;
    }

    private Cache getCache() {
        return this.getCache(LYRICS);
    }

    public void shutdown() {
        this.getCache().dispose();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

