/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PointedList<T>
implements Serializable {
    private static final long serialVersionUID = 5516540213103483594L;
    private List<T> list = null;
    private Integer pointer = 0;

    public PointedList() {
        this.list = new ArrayList<T>();
    }

    public PointedList(PointedList<? extends T> pointedList) {
        this.list = new ArrayList<T>(pointedList.getList());
        this.pointer = pointedList.pointer == null ? null : Integer.valueOf(pointedList.pointer);
    }

    public T getCurrentObject() {
        if (this.pointer == null || this.isEmpty() || this.size() <= this.pointer) {
            return null;
        }
        return this.get(this.pointer);
    }

    public T getNextObject(int n) {
        return this.getNextObject(false, n);
    }

    public T getPreviousObject(int n) {
        return this.getPreviousObject(false, n);
    }

    public T moveToNextObject() {
        return this.getNextObject(true, 1);
    }

    public T moveToPreviousObject() {
        return this.getPreviousObject(true, 1);
    }

    public void sort(Comparator<T> comparator) {
        if (this.isEmpty()) {
            return;
        }
        T t = this.getCurrentObject();
        Collections.sort(this.getList(), comparator);
        if (t != null) {
            this.setPointer(this.indexOf(t));
        }
    }

    public void shuffle() {
        if (this.isEmpty()) {
            return;
        }
        T t = this.getCurrentObject();
        Collections.shuffle(this.getList());
        if (t != null) {
            this.setPointer(this.indexOf(t));
        }
    }

    public void add(T t) {
        this.add(this.getList().size(), t);
    }

    public void add(int n, T t) {
        this.getList().add(n, t);
        if (this.size() > 1 && this.pointer != null && n <= this.pointer) {
            PointedList pointedList = this;
            Integer n2 = pointedList.pointer;
            Integer n3 = pointedList.pointer = Integer.valueOf(pointedList.pointer + 1);
        }
    }

    public boolean addAll(int n, Collection<? extends T> collection) {
        boolean bl = this.getList().addAll(n, collection);
        if (this.size() > 1 && this.pointer != null && n <= this.pointer) {
            this.pointer = this.pointer + collection.size();
        }
        return bl;
    }

    public T remove(int n) {
        if (n < 0 || this.getList().size() <= n) {
            return null;
        }
        if (this.pointer != null && n < this.pointer) {
            PointedList pointedList = this;
            Integer n2 = pointedList.pointer;
            Integer n3 = pointedList.pointer = Integer.valueOf(pointedList.pointer - 1);
        } else if (this.pointer != null && n == this.pointer && this.pointer == this.size() - 1) {
            this.pointer = this.size() - 2;
            if (this.pointer == -1) {
                this.pointer = null;
            }
        }
        return this.getList().remove(n);
    }

    public void clear() {
        this.pointer = 0;
        this.getList().clear();
    }

    public void replace(int n, T t) {
        if (n < 0 || this.getList().size() <= n || t == null) {
            return;
        }
        this.getList().remove(n);
        this.getList().add(n, t);
    }

    public void setPointer(Integer n) {
        this.pointer = n;
    }

    private T getNextObject(boolean bl, int n) {
        if (this.isEmpty()) {
            return null;
        }
        Integer n2 = null;
        if (this.pointer == null) {
            n2 = 0;
        } else {
            n2 = (this.pointer + n) % this.size();
            if (n2 < n && !this.isCyclic()) {
                n2 = null;
                return null;
            }
        }
        if (bl) {
            this.pointer = n2;
        }
        return this.get(n2);
    }

    private T getPreviousObject(boolean bl, int n) {
        if (this.isEmpty()) {
            return null;
        }
        Integer n2 = null;
        if (this.pointer == null) {
            n2 = this.size() - n;
        } else {
            n2 = this.pointer - n;
            if (n2 <= -n) {
                if (!this.isCyclic()) {
                    n2 = null;
                    return null;
                }
                n2 = this.size() - n;
            }
        }
        if (bl) {
            this.pointer = n2;
        }
        return this.get(n2);
    }

    public boolean isCyclic() {
        return true;
    }

    public Integer getPointer() {
        return this.pointer;
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public T get(int n) {
        if (n >= 0 && this.getList().size() > n) {
            return this.getList().get(n);
        }
        return null;
    }

    public int indexOf(T t) {
        return this.getList().indexOf(t);
    }

    public List<T> getList() {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        return this.list;
    }

    public boolean contains(T t) {
        return this.getList().contains(t);
    }

    public void setContent(List<T> list) {
        this.getList().addAll(list);
    }
}

