/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RankList<T>
implements Serializable {
    private static final long serialVersionUID = -4404155415144124761L;
    private List<T> order = new ArrayList<T>();
    private Map<T, Integer> count = new HashMap<T, Integer>();

    public void addItem(T t) {
        if (this.order.contains(t)) {
            Integer n = this.count.get(t);
            this.count.put(t, n + 1);
            this.moveUpOnList(t);
        } else {
            this.order.add(t);
            this.count.put(t, 1);
        }
    }

    public Integer getCount(T t) {
        return this.count.get(t);
    }

    public List<Integer> getNFirstElementCounts(int n) {
        int n2 = n;
        if (n2 <= -1 || n2 > this.order.size()) {
            n2 = this.order.size();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.count.get(this.order.get(i)));
        }
        return arrayList;
    }

    public List<T> getNFirstElements(int n) {
        if (n <= -1 || n > this.order.size()) {
            return new ArrayList<T>(this.order);
        }
        return new ArrayList<T>(this.order.subList(0, n));
    }

    public List<T> getOrder() {
        return new ArrayList<T>(this.order);
    }

    private void moveUpOnList(T t) {
        int n;
        int n2;
        int n3 = this.order.indexOf(t);
        if (n3 > 0 && (n2 = this.count.get(this.order.get(n3 - 1)).intValue()) < (n = this.count.get(this.order.get(n3)).intValue())) {
            T t2 = this.order.get(n3 - 1);
            T t3 = this.order.get(n3);
            this.order.remove(t2);
            this.order.remove(t3);
            this.order.add(n3 - 1, t3);
            this.order.add(n3, t2);
            this.moveUpOnList(t);
        }
    }

    public void replaceItem(T t, T t2) {
        int n = this.order.indexOf(t);
        this.order.remove(n);
        this.order.add(n, t2);
        Integer n2 = this.count.get(t);
        this.count.remove(t);
        this.count.put(t2, n2);
    }

    public int size() {
        return this.order.size();
    }

    public void clear() {
        this.order.clear();
        this.count.clear();
    }
}

