/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class NetworkUtils {
    private static Logger logger;

    private NetworkUtils() {
    }

    public static String encodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static URLConnection getConnection(String string, Proxy proxy) throws IOException {
        NetworkUtils.getLogger().debug("NETWORK     ", "Opening Connection With: ", string);
        URL uRL = new URL(string);
        URLConnection uRLConnection = proxy == null ? uRL.openConnection() : uRL.openConnection(proxy);
        uRLConnection.setRequestProperty("User-agent", "");
        uRLConnection.setConnectTimeout(60000);
        uRLConnection.setReadTimeout(60000);
        return uRLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URLConnection uRLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        finally {
            ClosingUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPostURL(HttpURLConnection httpURLConnection, String string) throws IOException {
        String string2;
        DataOutputStream dataOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            OutputStream outputStream = null;
            outputStream = httpURLConnection.getOutputStream();
            dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes(string);
            dataOutputStream.flush();
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException("Invalid HTTP return code");
            }
            StringBuilder stringBuilder = new StringBuilder();
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ClosingUtils.close(dataOutputStream);
            ClosingUtils.close(inputStream);
            throw throwable;
        }
        ClosingUtils.close(dataOutputStream);
        ClosingUtils.close(inputStream);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURL(URLConnection uRLConnection) throws IOException {
        String string;
        InputStream inputStream = null;
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ClosingUtils.close(inputStream);
            throw throwable;
        }
        ClosingUtils.close(inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURL(URLConnection uRLConnection, int n) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            String string = new String(byArray, 0, n2, "UTF-8");
            return string;
        }
        finally {
            ClosingUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURL(URLConnection uRLConnection, String string) throws IOException {
        String string2;
        InputStream inputStream = null;
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                stringBuilder.append(new String(byArray, 0, n, string));
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ClosingUtils.close(inputStream);
            throw throwable;
        }
        ClosingUtils.close(inputStream);
        return string2;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }
}

