/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.lookandfeel;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellRendererCode;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public abstract class AbstractLookAndFeel {
    public abstract String getName();

    public abstract String getDescription();

    public abstract void initializeLookAndFeel();

    public abstract void setLookAndFeel(String var1);

    public abstract String getDefaultSkin();

    public abstract List<String> getSkins();

    public boolean isDialogUndecorated() {
        return false;
    }

    public TreeCellRenderer getTreeCellRenderer(AbstractTreeCellRendererCode abstractTreeCellRendererCode) {
        return new LookAndFeelTreeCellRenderer(abstractTreeCellRendererCode);
    }

    public TableCellRenderer getTableCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
        return new LookAndFeelTableCellRenderer(abstractTableCellRendererCode);
    }

    public TableCellRenderer getTableHeaderCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
        return new LookAndFeelTableHeaderCellRenderer(abstractTableCellRendererCode);
    }

    public ListCellRenderer getListCellRenderer(AbstractListCellRendererCode abstractListCellRendererCode) {
        return new LookAndFeelListCellRenderer(abstractListCellRendererCode);
    }

    public void putClientProperties(JComponent jComponent) {
    }

    public boolean isCustomPlayerControlsSupported() {
        return false;
    }

    public Border getShadowBorder() {
        return null;
    }

    public void initializeFonts(Font font) {
    }

    public Font getDefaultFont() {
        return UIManager.getFont("Label.font");
    }

    private static final class LookAndFeelTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final AbstractTreeCellRendererCode code;
        private static final long serialVersionUID = 5424315832943108932L;

        private LookAndFeelTreeCellRenderer(AbstractTreeCellRendererCode abstractTreeCellRendererCode) {
            this.code = abstractTreeCellRendererCode;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return this.code.getComponent(component, jTree, object, bl, bl2, bl3, n, bl4);
        }
    }

    private static final class LookAndFeelTableCellRenderer
    extends DefaultTableCellRenderer {
        private final AbstractTableCellRendererCode code;
        private static final long serialVersionUID = 1L;

        private LookAndFeelTableCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
            this.code = abstractTableCellRendererCode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.code.getComponent(component, jTable, object, bl, bl2, n, n2);
        }
    }

    private static final class LookAndFeelTableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private final AbstractTableCellRendererCode code;
        private static final long serialVersionUID = 1L;

        private LookAndFeelTableHeaderCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
            this.code = abstractTableCellRendererCode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.code.getComponent(component, jTable, object, bl, bl2, n, n2);
        }
    }

    private static final class LookAndFeelListCellRenderer
    extends DefaultListCellRenderer {
        private final AbstractListCellRendererCode code;
        private static final long serialVersionUID = 2572603555660744197L;

        private LookAndFeelListCellRenderer(AbstractListCellRendererCode abstractListCellRendererCode) {
            this.code = abstractListCellRendererCode;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            return this.code.getComponent(component, jList, object, n, bl, bl2);
        }
    }
}

