/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.gui.renderers.JLabelTableCellRendererCode;
import net.sourceforge.atunes.gui.renderers.StringTableCellRendererCode;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.columns.PlayListColumnSet;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;

public final class PlayListColumnModel
extends AbstractCommonColumnModel {
    private static final long serialVersionUID = -2211160302611944001L;

    public PlayListColumnModel(PlayListTable playListTable) {
        super(playListTable, PlayListColumnSet.getInstance());
        this.enableColumnChange(true);
    }

    @Override
    protected void reapplyFilter() {
        ControllerProxy.getInstance().getPlayListController().reapplyFilter();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        this.updateColumnSettings(tableColumn);
    }

    @Override
    public AbstractTableCellRendererCode getRendererCodeFor(Class<?> clazz) {
        if (clazz.equals(Integer.class)) {
            return new AbstractTableCellRendererCode(){

                @Override
                public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component2 = component;
                    ((JLabel)component2).setText(null);
                    if (PlayListHandler.getInstance().isCurrentVisibleRowPlaying(n)) {
                        ((JLabel)component2).setIcon(PlayListTable.PlayState.getPlayStateIcon(((PlayListTable)PlayListColumnModel.this.getTable()).getPlayState()));
                    } else {
                        ((JLabel)component2).setIcon(Images.getImage("empty.png"));
                    }
                    ((JLabel)component2).setHorizontalAlignment(PlayListColumnModel.this.getColumnAlignment(n2));
                    return component2;
                }
            };
        }
        if (clazz.equals(String.class)) {
            return new PlayListStringTableCellRendererCode(this);
        }
        if (clazz.equals(JLabel.class)) {
            return new PlayListJLabelTableCellRendererCode(this);
        }
        return super.getRendererCodeFor(clazz);
    }

    private static final class PlayListStringTableCellRendererCode
    extends StringTableCellRendererCode {
        private PlayListStringTableCellRendererCode(AbstractCommonColumnModel abstractCommonColumnModel) {
            super(abstractCommonColumnModel);
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = super.getComponent(component, jTable, object, bl, bl2, n, n2);
            ((JLabel)component2).setFont(PlayListHandler.getInstance().isCurrentVisibleRowPlaying(n) ? Fonts.getPlayListSelectedItemFont() : Fonts.getPlayListFont());
            return component2;
        }
    }

    private static final class PlayListJLabelTableCellRendererCode
    extends JLabelTableCellRendererCode {
        private PlayListJLabelTableCellRendererCode(AbstractCommonColumnModel abstractCommonColumnModel) {
            super(abstractCommonColumnModel);
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = super.getComponent(component, jTable, object, bl, bl2, n, n2);
            ((JLabel)component2).setFont(PlayListHandler.getInstance().isCurrentVisibleRowPlaying(n) ? Fonts.getPlayListSelectedItemFont() : Fonts.getPlayListFont());
            return component2;
        }
    }
}

