/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JTable;
import net.sourceforge.atunes.gui.model.AbstractColumnSetTableModel;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;

public class ColumnSetRowSorter {
    private JTable table;
    private AbstractColumnSetTableModel model;
    private AbstractCommonColumnModel columnModel;

    public ColumnSetRowSorter(JTable jTable, AbstractColumnSetTableModel abstractColumnSetTableModel, AbstractCommonColumnModel abstractCommonColumnModel) {
        this.table = jTable;
        this.model = abstractColumnSetTableModel;
        this.columnModel = abstractCommonColumnModel;
        this.setListeners();
    }

    private void setListeners() {
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getButton() == 1 && (n = ColumnSetRowSorter.this.table.getTableHeader().getColumnModel().getColumnIndexAtX(mouseEvent.getX())) != -1) {
                    AbstractColumn abstractColumn = ColumnSetRowSorter.this.columnModel.getColumnObject(n);
                    AbstractColumn abstractColumn2 = ColumnSetRowSorter.this.getColumnSorted();
                    if (abstractColumn2 != null && !abstractColumn2.equals(abstractColumn)) {
                        abstractColumn2.setColumnSort(null);
                    }
                    if (abstractColumn.isSortable()) {
                        ColumnSetRowSorter.this.sort(abstractColumn.getComparator(true));
                    }
                }
            }
        });
    }

    private AbstractColumn getColumnSorted() {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            if (this.columnModel.getColumnObject(i).getColumnSort() == null) continue;
            return this.columnModel.getColumnObject(i);
        }
        return null;
    }

    protected void sort(Comparator<AudioObject> comparator) {
        this.model.sort(comparator);
        this.model.refresh(0);
    }
}

