/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls.playList;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.model.AudioObjectsSource;
import net.sourceforge.atunes.gui.model.PlayListColumnModel;
import net.sourceforge.atunes.gui.model.TransferableList;
import net.sourceforge.atunes.gui.renderers.ColumnRenderers;
import net.sourceforge.atunes.gui.views.controls.ColumnSetPopupMenu;
import net.sourceforge.atunes.gui.views.controls.ColumnSetRowSorter;
import net.sourceforge.atunes.gui.views.menus.PlayListMenu;
import net.sourceforge.atunes.kernel.modules.draganddrop.PlayListDragableRow;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListTableModel;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;

public final class PlayListTable
extends JTable
implements DragSourceListener,
DragGestureListener,
AudioObjectsSource {
    private static final long serialVersionUID = 9209069236823917569L;
    private PlayState playState = PlayState.STOPPED;
    private JPopupMenu menu;
    private DragSource dragSource;

    public PlayListTable() {
        this.setSelectionMode(2);
        this.setShowGrid(false);
        this.setDropMode(DropMode.ON);
        PlayListTableModel playListTableModel = new PlayListTableModel();
        this.setModel(playListTableModel);
        PlayListColumnModel playListColumnModel = new PlayListColumnModel(this);
        this.setColumnModel(playListColumnModel);
        new ColumnSetRowSorter(this, playListTableModel, playListColumnModel);
        new ColumnSetPopupMenu(this, playListColumnModel);
        this.setAutoResizeMode(0);
        ColumnRenderers.addRenderers(this, playListColumnModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        inputMap.put(keyStroke, "none");
        this.menu = new JPopupMenu();
        PlayListMenu.fillPopUpMenu(this.menu, this);
        GuiUtils.applyComponentOrientation(this.menu);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        if (this.getRowHeight() < 16) {
            this.setRowHeight(16);
        }
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public PlayState getPlayState() {
        return this.playState;
    }

    public void setPlayState(PlayState playState) {
        this.playState = playState;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (!(inputEvent instanceof MouseEvent) || ((MouseEvent)inputEvent).getButton() != 1) {
            return;
        }
        ArrayList<PlayListDragableRow> arrayList = new ArrayList<PlayListDragableRow>();
        int[] nArray = this.getSelectedRows();
        List<AudioObject> list = PlayListHandler.getInstance().getSelectedAudioObjects();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new PlayListDragableRow(list.get(i), nArray[i]));
        }
        TransferableList transferableList = new TransferableList(arrayList);
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, transferableList, this);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public List<AudioObject> getSelectedAudioObjects() {
        return PlayListHandler.getInstance().getSelectedAudioObjects();
    }

    public static enum PlayState {
        STOPPED,
        PLAYING,
        PAUSED,
        NONE;


        public static ImageIcon getPlayStateIcon(PlayState playState) {
            switch (playState) {
                case PLAYING: {
                    return Images.getImage("playTiny.png");
                }
                case STOPPED: {
                    return Images.getImage("stopTiny.png");
                }
                case PAUSED: {
                    return Images.getImage("pauseTiny.png");
                }
                case NONE: {
                    return Images.getImage("empty.png");
                }
            }
            return Images.getImage("empty.png");
        }
    }
}

