/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.gui.views.controls.ScrollableFlowPanel;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class CoverNavigatorFrame
extends CustomFrame {
    private static final long serialVersionUID = -1744765531225480303L;
    private JList list;
    private JPanel coversPanel;
    private JButton coversButton;

    public CoverNavigatorFrame(List<Artist> list, Component component) {
        super(I18nUtils.getString("COVER_NAVIGATOR"), GuiUtils.getComponentWidthForResolution(1280, 850), GuiUtils.getComponentHeightForResolution(1024, 650), component);
        this.setDefaultCloseOperation(2);
        this.setContent(list);
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    public JButton getCoversButton() {
        return this.coversButton;
    }

    public JPanel getCoversPanel() {
        return this.coversPanel;
    }

    public JList getList() {
        return this.list;
    }

    private void setContent(List<Artist> list) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.coversPanel = new ScrollableFlowPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(3);
        this.coversPanel.setLayout(flowLayout);
        this.list = new JList<Object>(list.toArray());
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setMinimumSize(new Dimension(200, 0));
        JScrollPane jScrollPane2 = new JScrollPane(this.coversPanel);
        jScrollPane2.setBorder(BorderFactory.createLineBorder(GuiUtils.getBorderColor()));
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        this.coversButton = new JButton(I18nUtils.getString("GET_COVERS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.coversButton, gridBagConstraints);
        this.add(jPanel);
    }
}

