/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalFrame;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class EditTagDialog
extends AbstractCustomModalFrame {
    private static final long serialVersionUID = 3395292301087643037L;
    private JCheckBox titleCheckBox;
    private JTextField titleTextField;
    private JCheckBox albumCheckBox;
    private JComboBox albumTextField;
    private JCheckBox artistCheckBox;
    private JComboBox artistTextField;
    private JCheckBox yearCheckBox;
    private JTextField yearTextField;
    private JCheckBox genreCheckBox;
    private JComboBox genreComboBox;
    private JCheckBox commentCheckBox;
    private JTextArea commentTextArea;
    private JCheckBox trackNumberCheckBox;
    private JTextField trackNumberTextField;
    private JCheckBox discNumberCheckBox;
    private JTextField discNumberTextField;
    private JCheckBox coverCheckBox;
    private JLabel cover;
    private JButton coverButton;
    private JButton removeCoverButton;
    private JCheckBox lyricsCheckBox;
    private JTextArea lyricsTextArea;
    private JCheckBox composerCheckBox;
    private JTextField composerTextField;
    private JCheckBox albumArtistCheckBox;
    private JTextField albumArtistTextField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton nextButton;
    private JButton prevButton;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public EditTagDialog(JFrame jFrame, boolean bl) {
        super(jFrame, 500, 600);
        this.setTitle(I18nUtils.getString("EDIT_TAG"));
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addTab(I18nUtils.getString("TAGS"), this.getTagEditTab());
        this.tabbedPane.addTab(I18nUtils.getString("COVER"), this.getCoverTab());
        this.add((Component)this.getOKAndCancelButtonPanel(bl), "South");
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private JPanel getOKAndCancelButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        if (bl) {
            jPanel.add((Component)this.prevButton, gridBagConstraints);
            jPanel.add((Component)this.nextButton, gridBagConstraints);
        }
        return jPanel;
    }

    public static void main(String[] stringArray) {
        new EditTagDialog(null, true).setVisible(true);
    }

    public JTextField getAlbumArtistTextField() {
        return this.albumArtistTextField;
    }

    public JComboBox getAlbumTextField() {
        return this.albumTextField;
    }

    public JComboBox getArtistTextField() {
        return this.artistTextField;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JTextArea getCommentTextArea() {
        return this.commentTextArea;
    }

    public JTextField getComposerTextField() {
        return this.composerTextField;
    }

    private JPanel getCoverTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        jPanel2.setLayout(flowLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(flowLayout);
        this.coverCheckBox = new JCheckBox();
        jPanel3.add(this.coverCheckBox);
        this.genreComboBox.setEditable(true);
        this.cover = new JLabel();
        this.cover.setPreferredSize(new Dimension(400, 400));
        this.cover.setMinimumSize(new Dimension(400, 400));
        this.cover.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.coverButton = new JButton(I18nUtils.getString("EDIT_COVER"));
        this.removeCoverButton = new JButton(I18nUtils.getString("REMOVE_COVER"));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 20, 0));
        jPanel4.add(this.coverButton);
        jPanel4.add(this.removeCoverButton);
        this.coverCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setCoverSelected(EditTagDialog.this.coverCheckBox.isSelected());
            }
        });
        jPanel.add((Component)jPanel3, "North");
        jPanel2.add(this.cover);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel getTagEditTab() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.titleCheckBox = new JCheckBox();
        this.titleCheckBox.setFocusable(false);
        JLabel jLabel = new JLabel(I18nUtils.getString("TITLE"));
        this.titleTextField = new CustomTextField();
        this.titleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setTitleSelected(EditTagDialog.this.titleCheckBox.isSelected());
            }
        });
        this.titleCheckBox.setSelected(true);
        this.albumCheckBox = new JCheckBox();
        JLabel jLabel2 = new JLabel(I18nUtils.getString("ALBUM"));
        this.albumTextField = new JComboBox();
        this.albumTextField.setEditable(true);
        this.albumCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setAlbumSelected(EditTagDialog.this.albumCheckBox.isSelected());
            }
        });
        this.albumCheckBox.setSelected(true);
        this.artistCheckBox = new JCheckBox();
        JLabel jLabel3 = new JLabel(I18nUtils.getString("ARTIST"));
        this.artistTextField = new JComboBox();
        this.artistTextField.setEditable(true);
        this.artistCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setArtistSelected(EditTagDialog.this.artistCheckBox.isSelected());
            }
        });
        this.artistCheckBox.setSelected(true);
        this.yearCheckBox = new JCheckBox();
        JLabel jLabel4 = new JLabel(I18nUtils.getString("YEAR"));
        this.yearTextField = new CustomTextField();
        this.yearCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setYearSelected(EditTagDialog.this.yearCheckBox.isSelected());
            }
        });
        this.yearCheckBox.setSelected(true);
        this.genreCheckBox = new JCheckBox();
        JLabel jLabel5 = new JLabel(I18nUtils.getString("GENRE"));
        this.genreComboBox = new JComboBox();
        this.genreCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setGenreSelected(EditTagDialog.this.genreCheckBox.isSelected());
            }
        });
        this.genreCheckBox.setSelected(true);
        this.commentCheckBox = new JCheckBox();
        JLabel jLabel6 = new JLabel(I18nUtils.getString("COMMENT"));
        this.commentTextArea = new CustomTextArea();
        this.commentTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.commentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setCommentSelected(EditTagDialog.this.commentCheckBox.isSelected());
            }
        });
        this.commentCheckBox.setSelected(true);
        JScrollPane jScrollPane = new JScrollPane(this.commentTextArea);
        this.lyricsCheckBox = new JCheckBox();
        JLabel jLabel7 = new JLabel(I18nUtils.getString("LYRICS"));
        this.lyricsTextArea = new CustomTextArea();
        this.lyricsTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.lyricsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setLyricsSelected(EditTagDialog.this.lyricsCheckBox.isSelected());
            }
        });
        this.lyricsCheckBox.setSelected(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.lyricsTextArea);
        this.trackNumberCheckBox = new JCheckBox();
        JLabel jLabel8 = new JLabel(I18nUtils.getString("TRACK"));
        this.trackNumberTextField = new CustomTextField();
        this.trackNumberCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setTrackNumberSelected(EditTagDialog.this.trackNumberCheckBox.isSelected());
            }
        });
        this.trackNumberCheckBox.setSelected(true);
        this.discNumberCheckBox = new JCheckBox();
        JLabel jLabel9 = new JLabel(I18nUtils.getString("DISC_NUMBER"));
        this.discNumberTextField = new CustomTextField();
        this.discNumberCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setDiscNumberSelected(EditTagDialog.this.discNumberCheckBox.isSelected());
            }
        });
        this.discNumberCheckBox.setSelected(true);
        this.composerCheckBox = new JCheckBox();
        JLabel jLabel10 = new JLabel(I18nUtils.getString("COMPOSER"));
        this.composerTextField = new CustomTextField();
        this.composerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setComposerSelected(EditTagDialog.this.composerCheckBox.isSelected());
            }
        });
        this.composerCheckBox.setSelected(true);
        this.albumArtistCheckBox = new JCheckBox();
        JLabel jLabel11 = new JLabel(I18nUtils.getString("ALBUM_ARTIST"));
        this.albumArtistTextField = new CustomTextField();
        this.albumArtistCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTagDialog.this.setAlbumArtistSelected(EditTagDialog.this.albumArtistCheckBox.isSelected());
            }
        });
        this.albumArtistCheckBox.setSelected(true);
        this.okButton = new CustomButton(null, I18nUtils.getString("OK"));
        this.cancelButton = new CustomButton(null, I18nUtils.getString("CANCEL"));
        this.nextButton = new CustomButton(null, I18nUtils.getString("NEXT"));
        this.prevButton = new CustomButton(null, I18nUtils.getString("PREVIOUS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.titleCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.titleTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.albumArtistCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel11, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.albumArtistTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.artistCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.artistTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.albumCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.albumTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.yearCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.yearTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.trackNumberCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.trackNumberTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.discNumberCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.discNumberTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.genreCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.genreComboBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.composerCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.composerTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.commentCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.lyricsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        return jPanel;
    }

    public JComboBox getGenreComboBox() {
        return this.genreComboBox;
    }

    public JTextArea getLyricsTextArea() {
        return this.lyricsTextArea;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getPrevButton() {
        return this.prevButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JTextField getTitleTextField() {
        return this.titleTextField;
    }

    public JTextField getTrackNumberTextField() {
        return this.trackNumberTextField;
    }

    public JTextField getYearTextField() {
        return this.yearTextField;
    }

    public JLabel getCover() {
        return this.cover;
    }

    public JButton getCoverButton() {
        return this.coverButton;
    }

    public JButton getRemoveCoverButton() {
        return this.removeCoverButton;
    }

    public JCheckBox getTitleCheckBox() {
        return this.titleCheckBox;
    }

    public JCheckBox getAlbumCheckBox() {
        return this.albumCheckBox;
    }

    public JCheckBox getArtistCheckBox() {
        return this.artistCheckBox;
    }

    public JCheckBox getYearCheckBox() {
        return this.yearCheckBox;
    }

    public JCheckBox getGenreCheckBox() {
        return this.genreCheckBox;
    }

    public JCheckBox getCommentCheckBox() {
        return this.commentCheckBox;
    }

    public JCheckBox getTrackNumberCheckBox() {
        return this.trackNumberCheckBox;
    }

    public JCheckBox getCoverCheckBox() {
        return this.coverCheckBox;
    }

    public JCheckBox getLyricsCheckBox() {
        return this.lyricsCheckBox;
    }

    public JCheckBox getComposerCheckBox() {
        return this.composerCheckBox;
    }

    public JCheckBox getAlbumArtistCheckBox() {
        return this.albumArtistCheckBox;
    }

    public void setTitleSelected(boolean bl) {
        this.titleCheckBox.setSelected(bl);
        this.titleTextField.setEnabled(bl);
    }

    public void setAlbumArtistSelected(boolean bl) {
        this.albumArtistCheckBox.setSelected(bl);
        this.albumArtistTextField.setEnabled(bl);
    }

    public void setArtistSelected(boolean bl) {
        this.artistCheckBox.setSelected(bl);
        this.artistTextField.setEnabled(bl);
    }

    public void setYearSelected(boolean bl) {
        this.yearCheckBox.setSelected(bl);
        this.yearTextField.setEnabled(bl);
    }

    public void setGenreSelected(boolean bl) {
        this.genreCheckBox.setSelected(bl);
        this.genreComboBox.setEnabled(bl);
    }

    public void setTrackNumberSelected(boolean bl) {
        this.trackNumberCheckBox.setSelected(bl);
        this.trackNumberTextField.setEnabled(bl);
    }

    public void setDiscNumberSelected(boolean bl) {
        this.discNumberCheckBox.setSelected(bl);
        this.discNumberTextField.setEnabled(bl);
    }

    public void setCommentSelected(boolean bl) {
        this.commentCheckBox.setSelected(bl);
        this.commentTextArea.setEnabled(bl);
    }

    public void setCoverSelected(boolean bl) {
        this.coverCheckBox.setSelected(bl);
        this.coverButton.setEnabled(bl);
        this.removeCoverButton.setEnabled(bl);
    }

    public void setLyricsSelected(boolean bl) {
        this.lyricsCheckBox.setSelected(bl);
        this.lyricsTextArea.setEnabled(bl);
    }

    public void setComposerSelected(boolean bl) {
        this.composerCheckBox.setSelected(bl);
        this.composerTextField.setEnabled(bl);
    }

    public void setAlbumSelected(boolean bl) {
        this.albumCheckBox.setSelected(bl);
        this.albumTextField.setEnabled(bl);
    }

    public JCheckBox getDiscNumberCheckBox() {
        return this.discNumberCheckBox;
    }

    public JTextField getDiscNumberTextField() {
        return this.discNumberTextField;
    }
}

