/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.dialogs.SelectorDialog;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class EqualizerDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = 7295438534550341824L;
    private JSlider[] bands;
    private JLabel[] labels;

    public EqualizerDialog(JFrame jFrame) {
        super((Window)jFrame, 510, 300, true);
        this.setTitle(StringUtils.getString(I18nUtils.getString("EQUALIZER"), " - ", "aTunes", " ", Constants.VERSION.toShortString()));
        this.add(this.getContent());
        this.setResizable(false);
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private JSlider getNewJSlider() {
        JSlider jSlider = new JSlider(1, -32, 32, 0);
        jSlider.setInverted(true);
        jSlider.setPaintTicks(true);
        jSlider.setMajorTickSpacing(32);
        jSlider.setMinorTickSpacing(4);
        return jSlider;
    }

    private void setSliderValues() {
        int[] nArray = PlayerHandler.getInstance().getEqualizer().getEqualizerSettingsToShowInGUI();
        if (nArray != null) {
            for (int i = 0; i < 10; ++i) {
                this.bands[i].setValue(nArray[i]);
            }
        }
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String[] stringArray = new String[]{"31Hz", "62Hz", "125Hz", "250Hz", "500Hz", "1kHz", "2kHz", "4kHz", "8kHz", "16kHz"};
        this.bands = new JSlider[10];
        this.labels = new JLabel[10];
        for (int i = 0; i < 10; ++i) {
            this.bands[i] = this.getNewJSlider();
            this.labels[i] = new JLabel(stringArray[i]);
            this.labels[i].setFont(Fonts.getSmallFont());
        }
        JLabel jLabel = new JLabel(I18nUtils.getString("CAN_ONLY_CHANGE_WHEN_STOPPED"));
        JButton jButton = new JButton(I18nUtils.getString("LOAD_PRESET"));
        jButton.setFont(Fonts.getButtonFont());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = PlayerHandler.getInstance().getEqualizer().getPresetsNames();
                SelectorDialog selectorDialog = new SelectorDialog((Window)EqualizerDialog.this, I18nUtils.getString("LOAD_PRESET"), stringArray, null);
                selectorDialog.setVisible(true);
                Integer[] integerArray = PlayerHandler.getInstance().getEqualizer().getPresetByNameForShowInGUI(selectorDialog.getSelection());
                for (int i = 0; i < EqualizerDialog.this.bands.length; ++i) {
                    EqualizerDialog.this.bands[i].setValue(integerArray[i]);
                }
            }
        });
        JButton jButton2 = new JButton(I18nUtils.getString("OK"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlayerHandler.getInstance().getEqualizer().setEqualizerFromGUI(EqualizerDialog.this.bands);
                EqualizerDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(I18nUtils.getString("APPLY"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlayerHandler.getInstance().getEqualizer().setEqualizerFromGUI(EqualizerDialog.this.bands);
            }
        });
        JButton jButton4 = new JButton(I18nUtils.getString("CANCEL"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EqualizerDialog.this.setVisible(false);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        for (int i = 0; i < this.bands.length; ++i) {
            gridBagConstraints.gridx = i;
            jPanel.add((Component)this.bands[i], gridBagConstraints);
        }
        JLabel jLabel2 = new JLabel("+12db");
        jLabel2.setFont(Fonts.getSmallFont());
        JLabel jLabel3 = new JLabel("0");
        jLabel3.setFont(Fonts.getSmallFont());
        JLabel jLabel4 = new JLabel("-12db");
        jLabel4.setFont(Fonts.getSmallFont());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 50));
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        gridBagConstraints.gridx = 10;
        jPanel.add(jPanel2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        for (int i = 0; i < this.labels.length; ++i) {
            gridBagConstraints.gridx = i;
            jPanel.add((Component)this.labels[i], gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 15;
        jPanel.add((Component)jButton, gridBagConstraints);
        if (!PlayerHandler.getInstance().supportsCapability(PlayerEngineCapability.EQUALIZER_CHANGE)) {
            gridBagConstraints.gridy = 3;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton3);
        jPanel3.add(jButton2);
        jPanel3.add(jButton4);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setSliderValues();
        }
        super.setVisible(bl);
    }
}

