/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class InputDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -5789081662254435503L;
    private JTextField textField;
    private String result = null;

    public InputDialog(Window window, String string, Image image) {
        super(window, 400, 130, true);
        this.setResizable(false);
        if (image != null) {
            this.setIconImage(image);
        }
        this.setTitle(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.textField = new CustomTextField();
        JButton jButton = new JButton(I18nUtils.getString("OK"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.result = InputDialog.this.textField.getText();
                InputDialog.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        this.textField.addActionListener(actionListener);
        JButton jButton2 = new JButton(I18nUtils.getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.result = null;
                InputDialog.this.dispose();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        GridLayout gridLayout = new GridLayout(1, 2, 40, 0);
        JPanel jPanel2 = new JPanel(gridLayout);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 50, 0, 50);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setContent(jPanel);
        this.enableDisposeActionWithEscapeKey();
        this.setDefaultCloseOperation(2);
        GuiUtils.applyComponentOrientation(this);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
    }

    public static void main(String[] stringArray) {
        InputDialog inputDialog = new InputDialog(null, "JJ", null);
        inputDialog.show("sasas");
        System.out.println(inputDialog.getResult());
    }

    public String getResult() {
        return this.result;
    }

    public void show(String string) {
        this.textField.setText(string);
        this.textField.setSelectionStart(0);
        this.textField.setSelectionEnd(string != null ? string.length() : 0);
        this.setVisible(true);
    }
}

