/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PatternInputDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -5789081662254435503L;
    private JComboBox patternComboBox;
    private JTable patternPreviewTable;
    private JTable availablePatternsTable;
    private String previewString = null;
    private String result = null;
    private static final String[] PREVIEW_COLUMN_NAMES = new String[]{I18nUtils.getString("NAME"), I18nUtils.getString("VALUE")};

    public PatternInputDialog(Window window, final boolean bl) {
        super(window, 550, 350, true);
        this.setResizable(false);
        this.setIconImage(Images.getImage("logo16x16.png").getImage());
        this.setTitle(I18nUtils.getString("PATTERN_INPUT"));
        CustomTextArea customTextArea = new CustomTextArea(I18nUtils.getString("PATTERN_INPUT_INSTRUCTIONS"));
        customTextArea.setBorder(BorderFactory.createEmptyBorder());
        customTextArea.setWrapStyleWord(true);
        customTextArea.setEditable(false);
        customTextArea.setLineWrap(true);
        customTextArea.setOpaque(false);
        List<String> list = null;
        list = bl ? ApplicationState.getInstance().getMassiveRecognitionPatterns() : ApplicationState.getInstance().getRecognitionPatterns();
        if (list != null) {
            Collections.sort(list);
        }
        this.patternComboBox = new JComboBox<String>(list != null ? list.toArray(new String[list.size()]) : new String[]{});
        this.patternComboBox.setEditable(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.patternPreviewTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this.patternPreviewTable);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(I18nUtils.getString("PREVIEW")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.availablePatternsTable = new JTable();
        JScrollPane jScrollPane2 = new JScrollPane(this.availablePatternsTable);
        jPanel2.add((Component)jScrollPane2, "Center");
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18nUtils.getString("AVAILABLE_PATTERNS")));
        JButton jButton = new JButton(I18nUtils.getString("OK"));
        OkActionListener okActionListener = new OkActionListener(bl);
        jButton.addActionListener(okActionListener);
        JButton jButton2 = new JButton(I18nUtils.getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternInputDialog.this.result = null;
                PatternInputDialog.this.dispose();
            }
        });
        this.patternComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternInputDialog.this.previewPattern(bl);
            }
        });
        this.patternComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PatternInputDialog.this.previewPattern(bl);
                    }
                });
            }
        });
        GridLayout gridLayout = new GridLayout(1, 2, 30, 0);
        JPanel jPanel3 = new JPanel(gridLayout);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)customTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 30, 5, 30);
        jPanel4.add((Component)this.patternComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.3;
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        this.setContent(jPanel4);
        this.enableDisposeActionWithEscapeKey();
        this.setDefaultCloseOperation(2);
        GuiUtils.applyComponentOrientation(this);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
    }

    void previewPattern(boolean bl) {
        Map<String, String> map = AbstractPattern.getPatternMatches(((JTextField)this.patternComboBox.getEditor().getEditorComponent()).getText(), this.previewString, bl);
        Object[][] objectArray = new String[map.size()][2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            objectArray[n][0] = I18nUtils.getString(entry.getKey());
            objectArray[n][1] = entry.getValue();
            ++n;
        }
        ((DefaultTableModel)this.patternPreviewTable.getModel()).setDataVector(objectArray, PREVIEW_COLUMN_NAMES);
    }

    public String getResult() {
        return this.result;
    }

    public void show(List<AbstractPattern> list, String string) {
        this.previewString = string;
        this.patternComboBox.setSelectedIndex(-1);
        Object[][] objectArray = new String[list.size()][2];
        int n = 0;
        for (AbstractPattern object2 : list) {
            objectArray[n][0] = object2.getPattern();
            objectArray[n][1] = object2.getDescription();
            ++n;
        }
        this.patternPreviewTable.setAutoResizeMode(0);
        this.patternPreviewTable.setColumnModel(new PatternPreviewDefaultTableColumnModel());
        PatternPreviewDefaultTableModel patternPreviewDefaultTableModel = new PatternPreviewDefaultTableModel(new String[0][2], PREVIEW_COLUMN_NAMES);
        this.patternPreviewTable.setModel(patternPreviewDefaultTableModel);
        AvailablePatternsDefaultTableModel availablePatternsDefaultTableModel = new AvailablePatternsDefaultTableModel(objectArray, new String[]{I18nUtils.getString("PATTERN"), I18nUtils.getString("DESCRIPTION")});
        this.availablePatternsTable.setModel(availablePatternsDefaultTableModel);
        this.setVisible(true);
        this.patternComboBox.requestFocus();
    }

    private static final class PatternPreviewDefaultTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -1915883409261076543L;

        private PatternPreviewDefaultTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            super.addColumn(tableColumn);
            if (tableColumn.getHeaderValue().equals(I18nUtils.getString("NAME"))) {
                tableColumn.setPreferredWidth(100);
            } else {
                tableColumn.setPreferredWidth(230);
            }
        }
    }

    private static final class PatternPreviewDefaultTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 0L;

        private PatternPreviewDefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private static final class AvailablePatternsDefaultTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7475413284696491261L;

        private AvailablePatternsDefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private final class OkActionListener
    implements ActionListener {
        private final boolean massiveRecognition;

        private OkActionListener(boolean bl) {
            this.massiveRecognition = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PatternInputDialog.this.result = (String)PatternInputDialog.this.patternComboBox.getSelectedItem();
            if (PatternInputDialog.this.result != null && !PatternInputDialog.this.result.trim().equals("")) {
                for (AbstractPattern abstractPattern : AbstractPattern.getPatterns()) {
                    PatternInputDialog.this.result.replaceAll(abstractPattern.getPattern().toLowerCase(), abstractPattern.getPattern());
                }
                List<String> list = null;
                list = this.massiveRecognition ? ApplicationState.getInstance().getMassiveRecognitionPatterns() : ApplicationState.getInstance().getRecognitionPatterns();
                if (list == null) {
                    list = new ArrayList<String>();
                    if (this.massiveRecognition) {
                        ApplicationState.getInstance().setMassiveRecognitionPatterns(list);
                    } else {
                        ApplicationState.getInstance().setRecognitionPatterns(list);
                    }
                }
                if (!list.contains(PatternInputDialog.this.result)) {
                    list.add(PatternInputDialog.this.result);
                }
            }
            PatternInputDialog.this.dispose();
        }
    }
}

