/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomJFileChooser;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class DevicePanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 3331810461314007217L;
    private CustomJFileChooser locationFileChooser;
    private JRadioButton fileNameNoChangeRadioButton;
    private JRadioButton fileNameCustomizedRadioButton;
    private JTextField fileNamePatternTextField;
    private JRadioButton folderPathNoChangeRadioButton;
    private JRadioButton folderPathCustomizedRadioButton;
    private JTextField folderPathPatternTextField;
    private JTable availablePatternsTable;
    private JCheckBox copySameSongForDifferentAlbums;

    public DevicePanel() {
        super(I18nUtils.getString("DEVICE"));
        JLabel jLabel = new JLabel(I18nUtils.getString("DEVICE_DEFAULT_LOCATION"));
        this.locationFileChooser = new CustomJFileChooser(this, 20, 1);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(I18nUtils.getString("FILE_NAME")));
        this.fileNameNoChangeRadioButton = new JRadioButton(I18nUtils.getString("NO_CHANGE"));
        this.fileNameNoChangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePanel.this.fileNamePatternTextField.setEnabled(false);
            }
        });
        this.fileNameCustomizedRadioButton = new JRadioButton(I18nUtils.getString("CUSTOM"));
        this.fileNameCustomizedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePanel.this.fileNamePatternTextField.setEnabled(true);
            }
        });
        this.fileNamePatternTextField = new CustomTextField(10);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fileNameNoChangeRadioButton);
        buttonGroup.add(this.fileNameCustomizedRadioButton);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18nUtils.getString("FOLDER")));
        this.folderPathNoChangeRadioButton = new JRadioButton(I18nUtils.getString("FLAT"));
        this.folderPathNoChangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePanel.this.folderPathPatternTextField.setEnabled(false);
            }
        });
        this.folderPathCustomizedRadioButton = new JRadioButton(I18nUtils.getString("CUSTOM"));
        this.folderPathCustomizedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePanel.this.folderPathPatternTextField.setEnabled(true);
            }
        });
        this.folderPathPatternTextField = new CustomTextField(10);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.folderPathNoChangeRadioButton);
        buttonGroup2.add(this.folderPathCustomizedRadioButton);
        this.availablePatternsTable = new JTable();
        this.availablePatternsTable.setModel(new AvailablePatternsDefaultTableModel());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(250, 200));
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18nUtils.getString("AVAILABLE_PATTERNS")));
        jPanel3.add((Component)new JScrollPane(this.availablePatternsTable), "Center");
        this.copySameSongForDifferentAlbums = new JCheckBox(I18nUtils.getString("ALLOW_COPY_TO_DEVICE_SAME_SONG_FOR_DIFFERENT_ALBUMS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.fileNameNoChangeRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.fileNameCustomizedRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.fileNamePatternTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.folderPathNoChangeRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.folderPathCustomizedRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.folderPathPatternTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.locationFileChooser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.copySameSongForDifferentAlbums, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setDefaultDeviceLocation(this.locationFileChooser.getResult());
        String string = this.fileNameNoChangeRadioButton.isSelected() ? "" : this.fileNamePatternTextField.getText();
        applicationState.setDeviceFileNamePattern(string == null || string.trim().equals("") ? null : string);
        String string2 = this.folderPathNoChangeRadioButton.isSelected() ? "" : this.folderPathPatternTextField.getText();
        applicationState.setDeviceFolderPathPattern(string2 == null || string2.equals("") ? null : string2);
        applicationState.setAllowRepeatedSongsInDevice(this.copySameSongForDifferentAlbums.isSelected());
        return false;
    }

    private void setDefaultDeviceLocation(String string) {
        this.locationFileChooser.setText(string);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setDefaultDeviceLocation(applicationState.getDefaultDeviceLocation());
        if (applicationState.getDeviceFileNamePattern() == null || applicationState.getDeviceFileNamePattern().trim().equals("")) {
            this.fileNameNoChangeRadioButton.setSelected(true);
            this.fileNamePatternTextField.setEnabled(false);
        } else {
            this.fileNameCustomizedRadioButton.setSelected(true);
            this.fileNamePatternTextField.setEnabled(true);
            this.fileNamePatternTextField.setText(applicationState.getDeviceFileNamePattern());
        }
        if (applicationState.getDeviceFolderPathPattern() == null || applicationState.getDeviceFolderPathPattern().trim().equals("")) {
            this.folderPathNoChangeRadioButton.setSelected(true);
            this.folderPathPatternTextField.setEnabled(false);
        } else {
            this.folderPathCustomizedRadioButton.setSelected(true);
            this.folderPathPatternTextField.setEnabled(true);
            this.folderPathPatternTextField.setText(applicationState.getDeviceFolderPathPattern());
        }
        this.copySameSongForDifferentAlbums.setSelected(applicationState.isAllowRepeatedSongsInDevice());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("device.png");
    }

    private static class AvailablePatternsDefaultTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -3054134384773947174L;

        private AvailablePatternsDefaultTableModel() {
        }

        @Override
        public int getRowCount() {
            return AbstractPattern.getPatterns().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return AbstractPattern.getPatterns().get(n).getPattern();
            }
            return AbstractPattern.getPatterns().get(n).getDescription();
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? I18nUtils.getString("PATTERN") : I18nUtils.getString("VALUE");
        }
    }
}

