/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalFrame;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.ContextPanel;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class EditPreferencesDialog
extends AbstractCustomModalFrame {
    private static final long serialVersionUID = -4759149194433605946L;
    private JButton ok;
    private JButton cancel;
    private JPanel options;
    private JList list;
    private AbstractPreferencesPanel[] panels;

    public EditPreferencesDialog(JFrame jFrame) {
        super(jFrame, GuiUtils.getComponentWidthForResolution(1280, 1000), GuiUtils.getComponentHeightForResolution(1024, 700));
        this.setResizable(true);
        this.setTitle(I18nUtils.getString("PREFERENCES"));
        this.add(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    public static void main(String[] stringArray) {
        new EditPreferencesDialog(null).setVisible(true);
    }

    public ContextPanel getContextPanel() {
        return (ContextPanel)this.panels[6];
    }

    public JButton getCancel() {
        return this.cancel;
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.list = new JList();
        this.list.setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getListCellRenderer(new PreferencesListCellRendererCode()));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setMinimumSize(new Dimension(200, 0));
        this.options = new JPanel();
        this.ok = new CustomButton(null, I18nUtils.getString("OK"));
        this.cancel = new CustomButton(null, I18nUtils.getString("CANCEL"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.options, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public JList getList() {
        return this.list;
    }

    public JButton getOk() {
        return this.ok;
    }

    public void setListModel(ListModel listModel) {
        this.list.setModel(listModel);
    }

    public void setPanels(AbstractPreferencesPanel[] abstractPreferencesPanelArray) {
        this.panels = abstractPreferencesPanelArray;
        this.options.setLayout(new CardLayout());
        for (int i = 0; i < abstractPreferencesPanelArray.length; ++i) {
            this.options.add(Integer.toString(i), abstractPreferencesPanelArray[i]);
        }
        GuiUtils.applyComponentOrientation(this);
    }

    public void showPanel(int n) {
        ((CardLayout)this.options.getLayout()).show(this.options, Integer.toString(n));
    }

    private static class PreferencesListCellRendererCode
    extends AbstractListCellRendererCode {
        private PreferencesListCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)component;
            AbstractPreferencesPanel abstractPreferencesPanel = (AbstractPreferencesPanel)object;
            jLabel.setText(abstractPreferencesPanel.getTitle());
            jLabel.setIcon(abstractPreferencesPanel.getIcon());
            return jLabel;
        }
    }
}

