/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.fullScreen;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.Cover3D;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.ImageUtils;

public final class CoverFlow
extends JPanel {
    private static final long serialVersionUID = -5982158797052430789L;
    private Logger logger;
    private List<Cover3D> covers;
    private Map<AudioObject, Image> cachedImages = new HashMap<AudioObject, Image>();

    CoverFlow() {
        super(new GridBagLayout());
        this.covers = new ArrayList<Cover3D>();
        this.covers.add(new Cover3D(0));
        this.covers.add(new Cover3D(0));
        this.covers.add(new Cover3D(0));
        this.covers.add(new Cover3D(0));
        this.covers.add(new Cover3D(0));
        this.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.covers.get(0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.covers.get(1), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.covers.get(2), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.covers.get(3), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.add((Component)this.covers.get(4), gridBagConstraints);
    }

    void paint(List<AudioObject> list) {
        int n = 0;
        for (AudioObject audioObject : list) {
            this.paint(audioObject, this.covers.get(n), n == 2);
            ++n;
        }
    }

    private void paint(AudioObject audioObject, Cover3D cover3D, boolean bl) {
        if (audioObject == null) {
            return;
        }
        new PaintCoversSwingWorker(cover3D, audioObject).execute();
    }

    protected Image getPicture(AudioFile audioFile) {
        ImageIcon[] imageIconArray;
        Image image = LastFmService.getInstance().getAlbumImage(audioFile.getArtist(), audioFile.getAlbum());
        if (image == null && (imageIconArray = AudioFilePictureUtils.getPicturesForFile(audioFile, -1, -1)) != null && imageIconArray.length > 0) {
            image = imageIconArray[0].getImage();
        }
        if (image == null) {
            image = Images.getImage("noCover.png").getImage();
        }
        return image;
    }

    protected void setPicture(AudioObject audioObject, Image image, Cover3D cover3D) {
        if (image == null) {
            cover3D.setImage(null);
            return;
        }
        if (audioObject == null) {
            cover3D.setImage(ImageUtils.scaleImageBicubic(Images.getImage("noCover.png").getImage(), this.getImageSize(this.covers.indexOf(cover3D)), this.getImageSize(this.covers.indexOf(cover3D))));
        } else {
            int n = this.getImageSize(this.covers.indexOf(cover3D));
            ImageIcon imageIcon = ImageUtils.scaleImageBicubic(image, n, n);
            cover3D.setImage(imageIcon);
        }
    }

    private int getImageSize(int n) {
        if (n == 2) {
            return 300;
        }
        if (n == 1 || n == 3) {
            return 225;
        }
        return 168;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class PaintCoversSwingWorker
    extends SwingWorker<Image, Void> {
        private final Cover3D cover;
        private final AudioObject audioObject;

        private PaintCoversSwingWorker(Cover3D cover3D, AudioObject audioObject) {
            this.cover = cover3D;
            this.audioObject = audioObject;
        }

        @Override
        protected Image doInBackground() throws Exception {
            if (this.audioObject instanceof Radio) {
                return Images.getImage("radio_big.png").getImage();
            }
            if (this.audioObject instanceof PodcastFeedEntry) {
                return Images.getImage("rss_big.png").getImage();
            }
            if (CoverFlow.this.cachedImages.containsKey(this.audioObject)) {
                return (Image)CoverFlow.this.cachedImages.get(this.audioObject);
            }
            Image image = CoverFlow.this.getPicture((AudioFile)this.audioObject);
            CoverFlow.this.cachedImages.put(this.audioObject, image);
            return image;
        }

        @Override
        protected void done() {
            try {
                Image image = (Image)this.get();
                CoverFlow.this.setPicture(this.audioObject, image, this.cover);
            }
            catch (InterruptedException interruptedException) {
                CoverFlow.this.getLogger().error("IMAGE       ", interruptedException);
            }
            catch (ExecutionException executionException) {
                CoverFlow.this.getLogger().error("IMAGE       ", executionException);
            }
        }
    }
}

