/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.properties.PropertiesDialog;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

final class AudioFilePropertiesDialog
extends PropertiesDialog {
    private static final long serialVersionUID = 7504320983331038543L;
    private Logger logger;
    private JLabel pictureLabel;
    private JLabel fileNameLabel;
    private JLabel pathLabel;
    private JLabel songLabel;
    private JLabel artistLabel;
    private JLabel albumArtistLabel;
    private JLabel composerLabel;
    private JLabel albumLabel;
    private JLabel durationLabel;
    private JLabel trackLabel;
    private JLabel discNumberLabel;
    private JLabel yearLabel;
    private JLabel genreLabel;
    private JLabel bitrateLabel;
    private JLabel frequencyLabel;
    private AudioFile file;

    AudioFilePropertiesDialog(AudioFile audioFile, JFrame jFrame) {
        super(AudioFilePropertiesDialog.getTitleText(audioFile), jFrame);
        this.file = audioFile;
        this.setAudioObject(audioFile);
        this.addContent();
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
    }

    private static String getTitleText(AudioFile audioFile) {
        return StringUtils.getString(I18nUtils.getString("INFO_OF_FILE"), " ", audioFile.getFile().getName());
    }

    private void addContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.pictureLabel = new JLabel();
        this.pictureLabel.setBorder((Border)new DropShadowBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.pictureLabel, gridBagConstraints);
        this.songLabel = new JLabel();
        this.songLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.songLabel, gridBagConstraints);
        this.artistLabel = new JLabel();
        this.artistLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.artistLabel, gridBagConstraints);
        this.albumArtistLabel = new JLabel();
        this.albumArtistLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.albumArtistLabel, gridBagConstraints);
        this.albumLabel = new JLabel();
        this.albumLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.albumLabel, gridBagConstraints);
        this.fileNameLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        this.pathLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.durationLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.durationLabel, gridBagConstraints);
        this.trackLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        jPanel.add((Component)this.trackLabel, gridBagConstraints);
        this.discNumberLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        jPanel.add((Component)this.discNumberLabel, gridBagConstraints);
        this.genreLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        jPanel.add((Component)this.genreLabel, gridBagConstraints);
        this.yearLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        jPanel.add((Component)this.yearLabel, gridBagConstraints);
        this.composerLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        jPanel.add((Component)this.composerLabel, gridBagConstraints);
        this.bitrateLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        jPanel.add((Component)this.bitrateLabel, gridBagConstraints);
        this.frequencyLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        jPanel.add((Component)this.frequencyLabel, gridBagConstraints);
        this.add(jPanel);
    }

    private void fillPicture() {
        new FillPictureSwingWorker().execute();
    }

    private void setContent() {
        this.fillPicture();
        this.songLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("SONG"), StringUtils.isEmpty(this.file.getTitle()) ? "-" : this.file.getTitle()));
        this.artistLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("ARTIST"), StringUtils.isEmpty(this.file.getArtist()) ? "-" : this.file.getArtist()));
        this.albumArtistLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("ALBUM_ARTIST"), StringUtils.isEmpty(this.file.getAlbumArtist()) ? "-" : this.file.getAlbumArtist()));
        this.albumLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("ALBUM"), StringUtils.isEmpty(this.file.getAlbum()) ? "-" : this.file.getAlbum()));
        this.fileNameLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("FILE"), this.file.getFile().getName()));
        this.pathLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("LOCATION"), this.file.getFile().getParent()));
        this.durationLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("DURATION"), StringUtils.seconds2String(this.file.getDuration())));
        this.trackLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("TRACK"), this.file.getTrackNumber() > 0 ? String.valueOf(this.file.getTrackNumber()) : "-"));
        this.discNumberLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("DISC_NUMBER"), this.file.getDiscNumber() > 0 ? String.valueOf(this.file.getDiscNumber()) : "-"));
        this.genreLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("GENRE"), StringUtils.isEmpty(this.file.getGenre()) ? "-" : this.file.getGenre()));
        this.yearLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("YEAR"), StringUtils.getNumberOrZero(this.file.getYear()) > 0 ? this.file.getYear() : "-"));
        this.composerLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("COMPOSER"), StringUtils.isEmpty(this.file.getComposer()) ? "-" : this.file.getComposer()));
        this.bitrateLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("BITRATE"), StringUtils.getString(Long.toString(this.file.getBitrate()), " Kbps")));
        this.frequencyLabel.setText(AudioFilePropertiesDialog.getHtmlFormatted(I18nUtils.getString("FREQUENCY"), StringUtils.getString(Integer.toString(this.file.getFrequency()), " Hz")));
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class FillPictureSwingWorker
    extends SwingWorker<ImageIcon, Void> {
        private FillPictureSwingWorker() {
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            return AudioFilePropertiesDialog.this.file.getImage(Constants.DIALOG_IMAGE_SIZE);
        }

        @Override
        protected void done() {
            try {
                ImageIcon imageIcon = (ImageIcon)this.get();
                if (imageIcon != null) {
                    AudioFilePropertiesDialog.this.pictureLabel.setIcon(imageIcon);
                } else {
                    AudioFilePropertiesDialog.this.pictureLabel.setIcon(Images.getImage("noCover_AudioFileProperties.png"));
                }
                AudioFilePropertiesDialog.this.pictureLabel.setVisible(true);
            }
            catch (InterruptedException interruptedException) {
                AudioFilePropertiesDialog.this.getLogger().error("IMAGE       ", interruptedException);
            }
            catch (ExecutionException executionException) {
                AudioFilePropertiesDialog.this.getLogger().error("IMAGE       ", executionException);
            }
        }
    }
}

